Mojo Public C++ API
===================

This directory contains C++ language bindings for the Mojo Public API.

A number of subdirectories provide wrappers for the lower-level C APIs (in
subdirectories of the same name, under mojo/public/c/). Typically, these
wrappers provide increased convenience and/or type-safety.

Other subdirectories provide support (static) libraries of various sorts. In
this case, the organization is to have the public interface for the library
defined in header files in the subdirectory itself and the implementation of the
library at a lower level, under a lib (sub)subdirectory. A developer should be
able to substitute their own implementation of any such support library, and
expect other support libraries, which may depend on that library, to work
properly.

Bindings
--------

The bindings/ subdirectory contains a support (static) library needed by the
code generated by the bindings generator tool (in mojo/public/tools/bindings/),
which translates Mojo IDL (.mojom) files into idiomatic C++ (among other
languages).

This library depends on the Environment library.

Environment
-----------

The environment/ subdirectory contains a support (static) library that
represents shared state needed to support the Bindings and GLES2 libraries.

This library depends on the Utility library.


GLES2
-----

The gles2/ subdirectory contains C++ wrappers (and some additional helpers) of
the API defined in mojo/public/c/gles2/ (which provides access to GLES2).

These wrappers depend on the Environment library.

Shell
-----

The shell/ subdirectory contains a support (static) library that aids in writing
Mojo applications and interacting with the Shell service.

System
------

The system/ subdirectory contains C++ wrappers (and some additional helpers) of
the API defined in mojo/public/c/system/, which defines the basic, "core" API,
especially used to communicate with Mojo services.

Test Support
------------

The test_support/ subdirectory contains C++ wrappers of the test-only API
defined in mojo/public/c/test_support/. It is not meant for general use by Mojo
applications.

Utility
-------

The utility/ subdirectory contains a support (static) library that provides
various basic functionality. Most notably, it provides an implementation of a
RunLoop based on MojoWaitMany() that applications may use as the basis for
asynchronous message processing.
