
    Polymer({
      is: 'paper-toggle-button',

      behaviors: [
        Polymer.PaperInkyFocusBehavior
      ],

      hostAttributes: {
        role: 'button',
        'aria-pressed': 'false',
        tabindex: 0
      },

      properties: {
        /**
         * Fired when the checked state changes due to user interaction.
         *
         * @event change
         */
        /**
         * Fired when the checked state changes.
         *
         * @event iron-change
         */
        /**
         * Gets or sets the state, `true` is checked and `false` is unchecked.
         *
         * @attribute checked
         * @type boolean
         * @default false
         */
        checked: {
          type: Boolean,
          value: false,
          reflectToAttribute: true,
          notify: true,
          observer: '_checkedChanged'
        },

        /**
         * If true, the button toggles the active state with each tap or press
         * of the spacebar.
         *
         * @attribute toggles
         * @type boolean
         * @default true
         */
        toggles: {
          type: Boolean,
          value: true,
          reflectToAttribute: true
        }
      },

      listeners: {
        track: '_ontrack'
      },

      ready: function() {
        this._isReady = true;
      },

      // button-behavior hook
      _buttonStateChanged: function() {
        if (this.disabled) {
          return;
        }
        if (this._isReady) {
          this.checked = this.active;
        }
      },

      _checkedChanged: function(checked) {
        this.active = this.checked;
        this.fire('iron-change');
      },

      _ontrack: function(event) {
        var track = event.detail;
        if (track.state === 'start') {
          this._trackStart(track);
        } else if (track.state === 'track') {
          this._trackMove(track);
        } else if (track.state === 'end') {
          this._trackEnd(track);
        }
      },

      _trackStart: function(track) {
        this._width = this.$.toggleBar.offsetWidth / 2;
        /*
         * keep an track-only check state to keep the dragging behavior smooth
         * while toggling activations
         */
        this._trackChecked = this.checked;
        this.$.toggleButton.classList.add('dragging');
      },

      _trackMove: function(track) {
        var dx = track.dx;
        this._x = Math.min(this._width,
            Math.max(0, this._trackChecked ? this._width + dx : dx));
        this.translate3d(this._x + 'px', 0, 0, this.$.toggleButton);
        this._userActivate(this._x > (this._width / 2));
      },

      _trackEnd: function(track) {
        this.$.toggleButton.classList.remove('dragging');
        this.transform('', this.$.toggleButton);
      }

    });
  