/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.base;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.base.Function;
import com.squareup.haha.guava.base.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class Predicates {
    private static final Ascii COMMA_JOINER$5f22bbb7;

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        Predicate<? super T> predicate = Ascii.checkNotNull(second);
        Predicate<? super T> predicate2 = Ascii.checkNotNull(first);
        return new AndPredicate(Arrays.asList(predicate2, predicate), 0);
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        if (target == null) {
            ObjectPredicate objectPredicate = ObjectPredicate.IS_NULL;
            return objectPredicate;
        }
        return new IsEqualToPredicate(target, 0);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        return new InPredicate(target, 0);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function, 0);
    }

    static {
        int n = 44;
        COMMA_JOINER$5f22bbb7 = new Ascii(",");
    }

    static final class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        private Predicate<B> p;
        private Function<A, ? extends B> f;

        private CompositionPredicate(Predicate<B> p, Function<A, ? extends B> f) {
            this.p = Ascii.checkNotNull(p);
            this.f = Ascii.checkNotNull(f);
        }

        @Override
        public final boolean apply(@Nullable A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof CompositionPredicate) {
                CompositionPredicate that = (CompositionPredicate)obj;
                return this.f.equals(that.f) && this.p.equals(that.p);
            }
            return false;
        }

        public final int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public final String toString() {
            return this.p.toString() + "(" + this.f.toString() + ")";
        }

        /* synthetic */ CompositionPredicate(Predicate x0, Function x1, byte by) {
            this(x0, x1);
        }
    }

    static final class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;

        private InPredicate(Collection<?> target) {
            this.target = Ascii.checkNotNull(target);
        }

        @Override
        public final boolean apply(@Nullable T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof InPredicate) {
                InPredicate that = (InPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        public final String toString() {
            return "Predicates.in(" + this.target + ")";
        }

        /* synthetic */ InPredicate(Collection x0, byte by) {
            this(x0);
        }
    }

    static final class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;

        private IsEqualToPredicate(T target) {
            this.target = target;
        }

        @Override
        public final boolean apply(T t) {
            return this.target.equals(t);
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public final String toString() {
            return "Predicates.equalTo(" + this.target + ")";
        }

        /* synthetic */ IsEqualToPredicate(Object x0, byte by) {
            this(x0);
        }
    }

    static final class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;

        private AndPredicate(List<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public final boolean apply(@Nullable T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).apply(t)) continue;
                return false;
            }
            return true;
        }

        public final int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof AndPredicate) {
                AndPredicate that = (AndPredicate)obj;
                return this.components.equals(that.components);
            }
            return false;
        }

        public final String toString() {
            return "Predicates.and(" + COMMA_JOINER$5f22bbb7.join(this.components) + ")";
        }

        /* synthetic */ AndPredicate(List x0, byte by) {
            this(x0);
        }
    }

    static final class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private Predicate<T> predicate;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = Ascii.checkNotNull(predicate);
        }

        @Override
        public final boolean apply(@Nullable T t) {
            return !this.predicate.apply(t);
        }

        public final int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof NotPredicate) {
                NotPredicate that = (NotPredicate)obj;
                return this.predicate.equals(that.predicate);
            }
            return false;
        }

        public final String toString() {
            return "Predicates.not(" + this.predicate.toString() + ")";
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<Object> {
        private static /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return true;
            }

            public final String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        private static /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return false;
            }

            public final String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o == null;
            }

            public final String toString() {
                return "Predicates.isNull()";
            }
        };
        private static /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o != null;
            }

            public final String toString() {
                return "Predicates.notNull()";
            }
        };

        private ObjectPredicate() {
        }

        /* synthetic */ ObjectPredicate(String x0, int x1, byte by) {
            this();
        }

        static {
            ObjectPredicate[] objectPredicateArray = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

