// generated by scripts/build_keyboard_adjacency_graphs.py
#include <zxcvbn/adjacency_graphs.hpp>

#include <array>
#include <initializer_list>
#include <utility>

#include "base/no_destructor.h"

namespace zxcvbn {

extern constexpr degree_t KEYBOARD_AVERAGE_DEGREE = 4.595745;
// slightly different for keypad/mac keypad, but close enough
extern constexpr degree_t KEYPAD_AVERAGE_DEGREE = 5.066667;

extern constexpr std::size_t KEYBOARD_STARTING_POSITIONS = 94;
extern constexpr std::size_t KEYPAD_STARTING_POSITIONS = 15;

const Graphs& graphs() {
  static base::NoDestructor<Graphs> graphs({
    {GraphTag::QWERTY, {
      {"!", {"`~", {}, {}, "2@", "qQ", {}}},
      {"\"", {";:", "[{", "]}", {}, {}, "/?"}},
      {"#", {"2@", {}, {}, "4$", "eE", "wW"}},
      {"$", {"3#", {}, {}, "5%", "rR", "eE"}},
      {"%", {"4$", {}, {}, "6^", "tT", "rR"}},
      {"&", {"6^", {}, {}, "8*", "uU", "yY"}},
      {"'", {";:", "[{", "]}", {}, {}, "/?"}},
      {"(", {"8*", {}, {}, "0)", "oO", "iI"}},
      {")", {"9(", {}, {}, "-_", "pP", "oO"}},
      {"*", {"7&", {}, {}, "9(", "iI", "uU"}},
      {"+", {"-_", {}, {}, {}, "]}", "[{"}},
      {",", {"mM", "kK", "lL", ".>", {}, {}}},
      {"-", {"0)", {}, {}, "=+", "[{", "pP"}},
      {".", {",<", "lL", ";:", "/?", {}, {}}},
      {"/", {".>", ";:", "'\"", {}, {}, {}}},
      {"0", {"9(", {}, {}, "-_", "pP", "oO"}},
      {"1", {"`~", {}, {}, "2@", "qQ", {}}},
      {"2", {"1!", {}, {}, "3#", "wW", "qQ"}},
      {"3", {"2@", {}, {}, "4$", "eE", "wW"}},
      {"4", {"3#", {}, {}, "5%", "rR", "eE"}},
      {"5", {"4$", {}, {}, "6^", "tT", "rR"}},
      {"6", {"5%", {}, {}, "7&", "yY", "tT"}},
      {"7", {"6^", {}, {}, "8*", "uU", "yY"}},
      {"8", {"7&", {}, {}, "9(", "iI", "uU"}},
      {"9", {"8*", {}, {}, "0)", "oO", "iI"}},
      {":", {"lL", "pP", "[{", "'\"", "/?", ".>"}},
      {";", {"lL", "pP", "[{", "'\"", "/?", ".>"}},
      {"<", {"mM", "kK", "lL", ".>", {}, {}}},
      {"=", {"-_", {}, {}, {}, "]}", "[{"}},
      {">", {",<", "lL", ";:", "/?", {}, {}}},
      {"?", {".>", ";:", "'\"", {}, {}, {}}},
      {"@", {"1!", {}, {}, "3#", "wW", "qQ"}},
      {"A", {{}, "qQ", "wW", "sS", "zZ", {}}},
      {"B", {"vV", "gG", "hH", "nN", {}, {}}},
      {"C", {"xX", "dD", "fF", "vV", {}, {}}},
      {"D", {"sS", "eE", "rR", "fF", "cC", "xX"}},
      {"E", {"wW", "3#", "4$", "rR", "dD", "sS"}},
      {"F", {"dD", "rR", "tT", "gG", "vV", "cC"}},
      {"G", {"fF", "tT", "yY", "hH", "bB", "vV"}},
      {"H", {"gG", "yY", "uU", "jJ", "nN", "bB"}},
      {"I", {"uU", "8*", "9(", "oO", "kK", "jJ"}},
      {"J", {"hH", "uU", "iI", "kK", "mM", "nN"}},
      {"K", {"jJ", "iI", "oO", "lL", ",<", "mM"}},
      {"L", {"kK", "oO", "pP", ";:", ".>", ",<"}},
      {"M", {"nN", "jJ", "kK", ",<", {}, {}}},
      {"N", {"bB", "hH", "jJ", "mM", {}, {}}},
      {"O", {"iI", "9(", "0)", "pP", "lL", "kK"}},
      {"P", {"oO", "0)", "-_", "[{", ";:", "lL"}},
      {"Q", {{}, "1!", "2@", "wW", "aA", {}}},
      {"R", {"eE", "4$", "5%", "tT", "fF", "dD"}},
      {"S", {"aA", "wW", "eE", "dD", "xX", "zZ"}},
      {"T", {"rR", "5%", "6^", "yY", "gG", "fF"}},
      {"U", {"yY", "7&", "8*", "iI", "jJ", "hH"}},
      {"V", {"cC", "fF", "gG", "bB", {}, {}}},
      {"W", {"qQ", "2@", "3#", "eE", "sS", "aA"}},
      {"X", {"zZ", "sS", "dD", "cC", {}, {}}},
      {"Y", {"tT", "6^", "7&", "uU", "hH", "gG"}},
      {"Z", {{}, "aA", "sS", "xX", {}, {}}},
      {"[", {"pP", "-_", "=+", "]}", "'\"", ";:"}},
      {"\\", {"]}", {}, {}, {}, {}, {}}},
      {"]", {"[{", "=+", {}, "\\|", {}, "'\""}},
      {"^", {"5%", {}, {}, "7&", "yY", "tT"}},
      {"_", {"0)", {}, {}, "=+", "[{", "pP"}},
      {"`", {{}, {}, {}, "1!", {}, {}}},
      {"a", {{}, "qQ", "wW", "sS", "zZ", {}}},
      {"b", {"vV", "gG", "hH", "nN", {}, {}}},
      {"c", {"xX", "dD", "fF", "vV", {}, {}}},
      {"d", {"sS", "eE", "rR", "fF", "cC", "xX"}},
      {"e", {"wW", "3#", "4$", "rR", "dD", "sS"}},
      {"f", {"dD", "rR", "tT", "gG", "vV", "cC"}},
      {"g", {"fF", "tT", "yY", "hH", "bB", "vV"}},
      {"h", {"gG", "yY", "uU", "jJ", "nN", "bB"}},
      {"i", {"uU", "8*", "9(", "oO", "kK", "jJ"}},
      {"j", {"hH", "uU", "iI", "kK", "mM", "nN"}},
      {"k", {"jJ", "iI", "oO", "lL", ",<", "mM"}},
      {"l", {"kK", "oO", "pP", ";:", ".>", ",<"}},
      {"m", {"nN", "jJ", "kK", ",<", {}, {}}},
      {"n", {"bB", "hH", "jJ", "mM", {}, {}}},
      {"o", {"iI", "9(", "0)", "pP", "lL", "kK"}},
      {"p", {"oO", "0)", "-_", "[{", ";:", "lL"}},
      {"q", {{}, "1!", "2@", "wW", "aA", {}}},
      {"r", {"eE", "4$", "5%", "tT", "fF", "dD"}},
      {"s", {"aA", "wW", "eE", "dD", "xX", "zZ"}},
      {"t", {"rR", "5%", "6^", "yY", "gG", "fF"}},
      {"u", {"yY", "7&", "8*", "iI", "jJ", "hH"}},
      {"v", {"cC", "fF", "gG", "bB", {}, {}}},
      {"w", {"qQ", "2@", "3#", "eE", "sS", "aA"}},
      {"x", {"zZ", "sS", "dD", "cC", {}, {}}},
      {"y", {"tT", "6^", "7&", "uU", "hH", "gG"}},
      {"z", {{}, "aA", "sS", "xX", {}, {}}},
      {"{", {"pP", "-_", "=+", "]}", "'\"", ";:"}},
      {"|", {"]}", {}, {}, {}, {}, {}}},
      {"}", {"[{", "=+", {}, "\\|", {}, "'\""}},
      {"~", {{}, {}, {}, "1!", {}, {}}},
    }},
    {GraphTag::DVORAK, {
      {"!", {"`~", {}, {}, "2@", "'\"", {}}},
      {"\"", {{}, "1!", "2@", ",<", "aA", {}}},
      {"#", {"2@", {}, {}, "4$", ".>", ",<"}},
      {"$", {"3#", {}, {}, "5%", "pP", ".>"}},
      {"%", {"4$", {}, {}, "6^", "yY", "pP"}},
      {"&", {"6^", {}, {}, "8*", "gG", "fF"}},
      {"'", {{}, "1!", "2@", ",<", "aA", {}}},
      {"(", {"8*", {}, {}, "0)", "rR", "cC"}},
      {")", {"9(", {}, {}, "[{", "lL", "rR"}},
      {"*", {"7&", {}, {}, "9(", "cC", "gG"}},
      {"+", {"/?", "]}", {}, "\\|", {}, "-_"}},
      {",", {"'\"", "2@", "3#", ".>", "oO", "aA"}},
      {"-", {"sS", "/?", "=+", {}, {}, "zZ"}},
      {".", {",<", "3#", "4$", "pP", "eE", "oO"}},
      {"/", {"lL", "[{", "]}", "=+", "-_", "sS"}},
      {"0", {"9(", {}, {}, "[{", "lL", "rR"}},
      {"1", {"`~", {}, {}, "2@", "'\"", {}}},
      {"2", {"1!", {}, {}, "3#", ",<", "'\""}},
      {"3", {"2@", {}, {}, "4$", ".>", ",<"}},
      {"4", {"3#", {}, {}, "5%", "pP", ".>"}},
      {"5", {"4$", {}, {}, "6^", "yY", "pP"}},
      {"6", {"5%", {}, {}, "7&", "fF", "yY"}},
      {"7", {"6^", {}, {}, "8*", "gG", "fF"}},
      {"8", {"7&", {}, {}, "9(", "cC", "gG"}},
      {"9", {"8*", {}, {}, "0)", "rR", "cC"}},
      {":", {{}, "aA", "oO", "qQ", {}, {}}},
      {";", {{}, "aA", "oO", "qQ", {}, {}}},
      {"<", {"'\"", "2@", "3#", ".>", "oO", "aA"}},
      {"=", {"/?", "]}", {}, "\\|", {}, "-_"}},
      {">", {",<", "3#", "4$", "pP", "eE", "oO"}},
      {"?", {"lL", "[{", "]}", "=+", "-_", "sS"}},
      {"@", {"1!", {}, {}, "3#", ",<", "'\""}},
      {"A", {{}, "'\"", ",<", "oO", ";:", {}}},
      {"B", {"xX", "dD", "hH", "mM", {}, {}}},
      {"C", {"gG", "8*", "9(", "rR", "tT", "hH"}},
      {"D", {"iI", "fF", "gG", "hH", "bB", "xX"}},
      {"E", {"oO", ".>", "pP", "uU", "jJ", "qQ"}},
      {"F", {"yY", "6^", "7&", "gG", "dD", "iI"}},
      {"G", {"fF", "7&", "8*", "cC", "hH", "dD"}},
      {"H", {"dD", "gG", "cC", "tT", "mM", "bB"}},
      {"I", {"uU", "yY", "fF", "dD", "xX", "kK"}},
      {"J", {"qQ", "eE", "uU", "kK", {}, {}}},
      {"K", {"jJ", "uU", "iI", "xX", {}, {}}},
      {"L", {"rR", "0)", "[{", "/?", "sS", "nN"}},
      {"M", {"bB", "hH", "tT", "wW", {}, {}}},
      {"N", {"tT", "rR", "lL", "sS", "vV", "wW"}},
      {"O", {"aA", ",<", ".>", "eE", "qQ", ";:"}},
      {"P", {".>", "4$", "5%", "yY", "uU", "eE"}},
      {"Q", {";:", "oO", "eE", "jJ", {}, {}}},
      {"R", {"cC", "9(", "0)", "lL", "nN", "tT"}},
      {"S", {"nN", "lL", "/?", "-_", "zZ", "vV"}},
      {"T", {"hH", "cC", "rR", "nN", "wW", "mM"}},
      {"U", {"eE", "pP", "yY", "iI", "kK", "jJ"}},
      {"V", {"wW", "nN", "sS", "zZ", {}, {}}},
      {"W", {"mM", "tT", "nN", "vV", {}, {}}},
      {"X", {"kK", "iI", "dD", "bB", {}, {}}},
      {"Y", {"pP", "5%", "6^", "fF", "iI", "uU"}},
      {"Z", {"vV", "sS", "-_", {}, {}, {}}},
      {"[", {"0)", {}, {}, "]}", "/?", "lL"}},
      {"\\", {"=+", {}, {}, {}, {}, {}}},
      {"]", {"[{", {}, {}, {}, "=+", "/?"}},
      {"^", {"5%", {}, {}, "7&", "fF", "yY"}},
      {"_", {"sS", "/?", "=+", {}, {}, "zZ"}},
      {"`", {{}, {}, {}, "1!", {}, {}}},
      {"a", {{}, "'\"", ",<", "oO", ";:", {}}},
      {"b", {"xX", "dD", "hH", "mM", {}, {}}},
      {"c", {"gG", "8*", "9(", "rR", "tT", "hH"}},
      {"d", {"iI", "fF", "gG", "hH", "bB", "xX"}},
      {"e", {"oO", ".>", "pP", "uU", "jJ", "qQ"}},
      {"f", {"yY", "6^", "7&", "gG", "dD", "iI"}},
      {"g", {"fF", "7&", "8*", "cC", "hH", "dD"}},
      {"h", {"dD", "gG", "cC", "tT", "mM", "bB"}},
      {"i", {"uU", "yY", "fF", "dD", "xX", "kK"}},
      {"j", {"qQ", "eE", "uU", "kK", {}, {}}},
      {"k", {"jJ", "uU", "iI", "xX", {}, {}}},
      {"l", {"rR", "0)", "[{", "/?", "sS", "nN"}},
      {"m", {"bB", "hH", "tT", "wW", {}, {}}},
      {"n", {"tT", "rR", "lL", "sS", "vV", "wW"}},
      {"o", {"aA", ",<", ".>", "eE", "qQ", ";:"}},
      {"p", {".>", "4$", "5%", "yY", "uU", "eE"}},
      {"q", {";:", "oO", "eE", "jJ", {}, {}}},
      {"r", {"cC", "9(", "0)", "lL", "nN", "tT"}},
      {"s", {"nN", "lL", "/?", "-_", "zZ", "vV"}},
      {"t", {"hH", "cC", "rR", "nN", "wW", "mM"}},
      {"u", {"eE", "pP", "yY", "iI", "kK", "jJ"}},
      {"v", {"wW", "nN", "sS", "zZ", {}, {}}},
      {"w", {"mM", "tT", "nN", "vV", {}, {}}},
      {"x", {"kK", "iI", "dD", "bB", {}, {}}},
      {"y", {"pP", "5%", "6^", "fF", "iI", "uU"}},
      {"z", {"vV", "sS", "-_", {}, {}, {}}},
      {"{", {"0)", {}, {}, "]}", "/?", "lL"}},
      {"|", {"=+", {}, {}, {}, {}, {}}},
      {"}", {"[{", {}, {}, {}, "=+", "/?"}},
      {"~", {{}, {}, {}, "1!", {}, {}}},
    }},
    {GraphTag::KEYPAD, {
      {"*", {"/", {}, {}, {}, "-", "+", "9", "8"}},
      {"+", {"9", "*", "-", {}, {}, {}, {}, "6"}},
      {"-", {"*", {}, {}, {}, {}, {}, "+", "9"}},
      {".", {"0", "2", "3", {}, {}, {}, {}, {}}},
      {"/", {{}, {}, {}, {}, "*", "9", "8", "7"}},
      {"0", {{}, "1", "2", "3", ".", {}, {}, {}}},
      {"1", {{}, {}, "4", "5", "2", "0", {}, {}}},
      {"2", {"1", "4", "5", "6", "3", ".", "0", {}}},
      {"3", {"2", "5", "6", {}, {}, {}, ".", "0"}},
      {"4", {{}, {}, "7", "8", "5", "2", "1", {}}},
      {"5", {"4", "7", "8", "9", "6", "3", "2", "1"}},
      {"6", {"5", "8", "9", "+", {}, {}, "3", "2"}},
      {"7", {{}, {}, {}, "/", "8", "5", "4", {}}},
      {"8", {"7", {}, "/", "*", "9", "6", "5", "4"}},
      {"9", {"8", "/", "*", "-", "+", {}, "6", "5"}},
    }},
    {GraphTag::MAC_KEYPAD, {
      {"*", {"/", {}, {}, {}, {}, {}, "-", "9"}},
      {"+", {"6", "9", "-", {}, {}, {}, {}, "3"}},
      {"-", {"9", "/", "*", {}, {}, {}, "+", "6"}},
      {".", {"0", "2", "3", {}, {}, {}, {}, {}}},
      {"/", {"=", {}, {}, {}, "*", "-", "9", "8"}},
      {"0", {{}, "1", "2", "3", ".", {}, {}, {}}},
      {"1", {{}, {}, "4", "5", "2", "0", {}, {}}},
      {"2", {"1", "4", "5", "6", "3", ".", "0", {}}},
      {"3", {"2", "5", "6", "+", {}, {}, ".", "0"}},
      {"4", {{}, {}, "7", "8", "5", "2", "1", {}}},
      {"5", {"4", "7", "8", "9", "6", "3", "2", "1"}},
      {"6", {"5", "8", "9", "-", "+", {}, "3", "2"}},
      {"7", {{}, {}, {}, "=", "8", "5", "4", {}}},
      {"8", {"7", {}, "=", "/", "9", "6", "5", "4"}},
      {"9", {"8", "=", "/", "*", "-", "+", "6", "5"}},
      {"=", {{}, {}, {}, {}, "/", "9", "8", "7"}},
    }},
  });

  return *graphs;
}

}
