/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTARGET_H
#define KMFTARGET_H

#include "netfilterobject.h"

// TQt includes

#include <tqptrlist.h>
#include <tqstring.h>
#include <tqdom.h>

// KDE includes
#include <tdemacros.h>
#include <kprocess.h>

// Project includes
#include "kmfnetzone.h"

#include "xmlnames.h"
class TQWidget;

namespace KMF {
class IPAddress;
class KMFError;
class KMFTargetConfig;
class KMFDoc;
class KMFNetwork;
class KMFRulesetDoc;
class KMFProcessWrapper;
class KMFInstallerInterface;
class KMFCompilerInterface;
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class TDE_EXPORT KMFTarget : public NetfilterObject {
	TQ_OBJECT
  
public:
	KMFTarget( NetfilterObject *parent, const char* name, const TQString& targetName, KMFNetwork* net );

    ~KMFTarget();
	
	virtual int type();
	virtual void clear();
	
	virtual const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	KMFNetZone* zone() const {
		return m_zone;
	}
	
	bool isLocalhost(); 
	bool isLocalExecuteTarget(); 
	
	const TQString& guiName() const {
		return m_guiName;
	};
	void setGuiName( const TQString& );

	const TQString& name();

	IPAddress* address() {
		return m_address;
	};
	
	void setAddress( const TQString& );
	
	int sshPort() const {
		return m_ssh_port;
	};
	
	void setSSHPort( int );
	
	bool readOnly() const {
		return m_readOnly;
	};
	void setReadOnly( bool );	

	bool isCurrentTarget();
	KMFNetwork* network();
	
	void setParentZone( KMFNetZone* );
	KMFError* tryAutoConfiguration();
	
	KMFTargetConfig* config();
	
	TQString toString();
	TQString toFriendlyString();
	const TQString& getFishUrl();
	
	
	KMFDoc* doc();
	
	KMFRulesetDoc* rulesetDoc();
	KMFInstallerInterface* installer();
	KMFCompilerInterface* compiler();
	
	protected: 
		TQGuardedPtr<KMFNetZone> m_zone;
		IPAddress *m_address;
		int m_ssh_port;
		TQString m_guiName;
		
	private:
		void ensureDoc();
		KMFTargetConfig *m_config;
		KMFDoc *m_doc;
		KMFNetwork *m_network;
		bool m_readOnly;
		TQString m_allOut;	
	signals:
		void sigTargetChanged( KMFTarget* );
};	
}
#endif
