/***************************************************************************
 *   Copyright (C) 2005 Paul Cifarelli <paul@cifarelli.net>              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HELIX_CONFIG_H_
#define _HELIX_CONFIG_H_

#include "plugin/pluginconfig.h"
#include <tqptrlist.h>
#include <tqtabwidget.h>
#include <tqvbox.h>

class TQGridLayout;
class KComboBox;
class TQCheckBox;
class KLineEdit;
class HelixEngine;

// since many preferences can be set in Helix, I'm planning on more config items later
// for now I'll just get the location of the Helix core/plugins for initializing
// the Helix core
class HelixConfigEntry : public TQObject
{
TQ_OBJECT
  
public:
   HelixConfigEntry( TQWidget *parent, Amarok::PluginConfig*,
                     int row, const TQString & description, const char *defaultvalue, const TQString & tooltip );
   HelixConfigEntry( TQWidget *parent, TQString &str, Amarok::PluginConfig*,
                     int row, const TQString & description, const char *defaultvalue, const TQString & tooltip );

   bool isChanged() const { return m_valueChanged; }
   void setUnchanged() { m_valueChanged = false; }
   const TQString& key() const { return m_key; }
   TQString stringValue() const { return m_stringValue; }
   int numValue() const { return m_numValue; }

private slots:
   void slotStringChanged( const TQString& );

private:
   KLineEdit *m_w;
   bool       m_valueChanged;
   int        m_numValue;
   TQString    m_key;
   TQString    m_stringValue;
};

class HelixSoundDevice : public TQObject
{
TQ_OBJECT
  
public:
   HelixSoundDevice( TQWidget *parent, Amarok::PluginConfig *config, int &row, HelixEngine *engine );
   bool save();
   void setSoundSystem( int api );
   bool isChanged() const { return m_changed; }
   void setUnchanged() { m_changed = false; }

private slots:
   void slotNewDevice( const TQString& );
   void slotStringChanged( const TQString& );
   void slotDeviceChecked( bool );

private:
   KComboBox* deviceComboBox;
   TQCheckBox* checkBox_outputDevice;
   KLineEdit* lineEdit_outputDevice;
   bool m_changed;
   HelixEngine *m_engine;
};


class HelixConfigDialogBase : public TQTabWidget
{
public:
   HelixConfigDialogBase( HelixEngine *engine, Amarok::PluginConfig *config, TQWidget *parent = 0 );
   ~HelixConfigDialogBase();

   virtual TQWidget *view() { return this; }
   virtual bool hasChanged() const;
   virtual bool isDefault() const;

   /** Save view state into configuration */
   virtual void save();

   void setSoundSystem( int api );
   void setEngine(HelixEngine *e) { m_engine = e; }

private:
   TQPtrList<HelixConfigEntry> entries;
   HelixConfigEntry *m_core;
   HelixConfigEntry *m_plugin;
   HelixConfigEntry *m_codec;
   HelixSoundDevice *m_device;
   HelixEngine *m_engine;
};

class HelixConfigDialog : public Amarok::PluginConfig
{
public:
   HelixConfigDialog( HelixEngine *engine, TQWidget *parent = 0 );
   ~HelixConfigDialog();

   virtual TQWidget *view() { return instance->view(); }
   virtual bool hasChanged() const { return instance->hasChanged(); }
   virtual bool isDefault() const { return instance->isDefault(); }

   virtual void save() { instance->save(); }
   static int setSoundSystem( int api );

private:
   static HelixConfigDialogBase *instance;
};


#endif
