// (c) 2005 Alexandre Pereira de Oliveira <aleprj@gmail.com>
// (c) 2003 Frerich Raabe <raabe@kde.org>
// See COPYING file for licensing information.

#ifndef TAGGUESSER_H
#define TAGGUESSER_H

#include <tqregexp.h>

class FileNameScheme
{
    public:
        typedef TQValueList<FileNameScheme> List;

        FileNameScheme()
            : m_cod()
            , m_titleField( -1 )
            , m_artistField( -1 )
            , m_albumField( -1 )
            , m_trackField( -1 )
            , m_commentField( -1 )
            , m_yearField( -1 )
            , m_composerField( -1 )
            , m_genreField( -1 )
        { }

        FileNameScheme( const TQString &s );

        bool matches( const TQString &s ) const;

        TQString title() const;
        TQString artist() const;
        TQString album() const;
        TQString track() const;
        TQString comment() const;
        TQString year() const;
        TQString composer() const;
        TQString genre() const;

        TQString pattern() const { return m_cod; };

    private:
        TQString composeRegExp( const TQString &s ) const;
        TQString m_cod;

        mutable TQRegExp m_regExp;

        int m_titleField;
        int m_artistField;
        int m_albumField;
        int m_trackField;
        int m_commentField;
        int m_yearField;
        int m_composerField;
        int m_genreField;
};

class TagGuesser
{
    public:

        enum Type { FileName = 0, MusicBrainz = 1 };

        static TQStringList schemeStrings();
        static void setSchemeStrings( const TQStringList &schemes );

        TagGuesser();
        TagGuesser( const TQString &absFileName );

        void guess( const TQString &absFileName );

        TQString title() const { return m_title; }
        TQString artist() const { return m_artist; }
        TQString album() const { return m_album; }
        TQString track() const { return m_track; }
        TQString comment() const { return m_comment; }
        TQString year() const { return m_year; }
        TQString composer() const { return m_composer; }
        TQString genre() const { return m_genre; }

    private:
        void loadSchemes();
        TQString capitalizeWords( const TQString &s );

        FileNameScheme::List m_schemes;
        TQString m_title;
        TQString m_artist;
        TQString m_album;
        TQString m_track;
        TQString m_comment;
        TQString m_year;
        TQString m_composer;
        TQString m_genre;
};

#endif /* TAGGUESSER_H */

