/***************************************************************************
    begin                : Tue Aug 31 21:59:58 EST 2004
    copyright            : (C) 2004 by Michael Pyne <michael.pyne@kdemail.net>
                           (C) 2006 by Ian Monroe <ian@monroe.nu>
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeconfig.h>
#include <tdeversion.h>
#include <kdialogbase.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdeio/job.h>
#include <tdelocale.h>
#include <kstdguiitem.h>
#include <kurl.h>

#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtimer.h>
#include <tqvbox.h>
#include <tqhbox.h>

#include "amarok.h"
#include "playlist.h"
#include "collectiondb.h"
#include "deletedialog.h"
#include "statusbar.h"

//////////////////////////////////////////////////////////////////////////////
// DeleteWidget implementation
//////////////////////////////////////////////////////////////////////////////

DeleteWidget::DeleteWidget(TQWidget *parent, const char *name)
    : DeleteDialogBase(parent, name)
{
    TDEConfigGroup messageGroup(TDEGlobal::config(), "FileRemover");

    bool deleteInstead = messageGroup.readBoolEntry("deleteInsteadOfTrash", false);
    slotShouldDelete(deleteInstead);
    ddShouldDelete->setChecked(deleteInstead);
}

void DeleteWidget::setFiles(const KURL::List &files)
{
    ddFileList->clear();
//    ddFileList->insertStringList(files);
    for( KURL::List::ConstIterator it = files.begin(); it != files.end(); it++)
    {
        if( (*it).isLocalFile() ) //path is nil for non-local
            ddFileList->insertItem( (*it).path() );
        else
            ddFileList->insertItem( (*it).url() );
    }
    ddNumFiles->setText(i18n("<b>1</b> file selected.", "<b>%n</b> files selected.", files.count()));
}

void DeleteWidget::slotShouldDelete(bool shouldDelete)
{
    if(shouldDelete) {
        ddDeleteText->setText(i18n("<qt>These items will be <b>permanently "
            "deleted</b> from your hard disk.</qt>"));
        ddWarningIcon->setPixmap(TDEGlobal::iconLoader()->loadIcon("messagebox_warning",
            TDEIcon::Desktop, TDEIcon::SizeLarge));
    }
    else {
        ddDeleteText->setText(i18n("<qt>These items will be moved to the Trash Bin.</qt>"));
        ddWarningIcon->setPixmap(TDEGlobal::iconLoader()->loadIcon("trashcan_full",
            TDEIcon::Desktop, TDEIcon::SizeLarge));
    }
}

//////////////////////////////////////////////////////////////////////////////
// DeleteDialog implementation
//////////////////////////////////////////////////////////////////////////////

DeleteDialog::DeleteDialog(TQWidget *parent, const char *name) :
    KDialogBase(Swallow, WStyle_DialogBorder, parent, name,
        true /* modal */, i18n("About to delete selected files"),
        Ok | Cancel, Cancel /* Default */, true /* separator */),
    m_trashGuiItem(i18n("&Send to Trash"), "trashcan_full")
{
    m_widget = new DeleteWidget(this, "delete_dialog_widget");
    setMainWidget(m_widget);

    m_widget->setMinimumSize(400, 300);
    setMinimumSize(410, 326);
    adjustSize();

    slotShouldDelete(shouldDelete());
    connect(m_widget->ddShouldDelete, TQ_SIGNAL(toggled(bool)), TQ_SLOT(slotShouldDelete(bool)));

}

bool DeleteDialog::confirmDeleteList(const KURL::List& condemnedFiles)
{
    m_widget->setFiles(condemnedFiles);

    return exec() == TQDialog::Accepted;
}

void DeleteDialog::setFiles(const KURL::List &files)
{
    m_widget->setFiles(files);
}

void DeleteDialog::accept()
{
    TDEConfigGroup messageGroup(TDEGlobal::config(), "FileRemover");

    // Save user's preference

    messageGroup.writeEntry("deleteInsteadOfTrash", shouldDelete());
    messageGroup.sync();

    KDialogBase::accept();
}

void DeleteDialog::slotShouldDelete(bool shouldDelete)
{
    setButtonGuiItem(Ok, shouldDelete ? KStdGuiItem::del() : m_trashGuiItem);
}

bool DeleteDialog::showTrashDialog(TQWidget* parent, const KURL::List& files)
{
    DeleteDialog dialog(parent);
    bool doDelete = dialog.confirmDeleteList(files);

    if( doDelete )
    {
        TDEIO::Job* job = 0;
        bool shouldDelete = dialog.shouldDelete();
        if ( ( shouldDelete && (job = TDEIO::del( files )) ) ||
             ( job = Amarok::trashFiles( files )   ) )
        {
            if(shouldDelete) //amarok::trashFiles already does the progress operation
                Amarok::StatusBar::instance()->newProgressOperation( job )
                    .setDescription( i18n("Deleting files") );
        }

    }

    return doDelete;
}
#include "deletedialog.moc"
