/***************************************************************************
 *   Copyright (C) 2003 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef HTMLEXPORTER_H
#define HTMLEXPORTER_H

#include <tqstring.h>
#include <tqtextstream.h>

class KProgress;

class Basket;
class Note;

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class HTMLExporter
{
  public:
	HTMLExporter(Basket *basket);
	~HTMLExporter();
  private:
	void prepareExport(Basket *basket, const TQString &fullPath);
	void exportBasket(Basket *basket, bool isSubBasket);
	void exportNote(Note *note, int indent);
	void writeBasketTree(Basket *currentBasket);
	void writeBasketTree(Basket *currentBasket, Basket *basket, int indent);

  public:
	TQString copyIcon(const TQString &iconName, int size);
	TQString copyFile(const TQString &srcPath, bool createIt);

  public:
	// Absolute path of the file name the user choosen:
	TQString filePath;          // eg.: "/home/seb/foo.html"
	TQString fileName;          // eg.: "foo.html"

	// Absolute & relative paths for the current basket to be exported:
	TQString basketFilePath;    // eg.: "/home/seb/foo.html" or "/home/seb/foo.html_files/baskets/basketN.html"
	TQString filesFolderPath;   // eg.: "/home/seb/foo.html_files/"
	TQString filesFolderName;   // eg.: "foo.html_files/" or "../"
	TQString iconsFolderPath;   // eg.: "/home/seb/foo.html_files/icons/"
	TQString iconsFolderName;   // eg.: "foo.html_files/icons/" or "../icons/"
	TQString imagesFolderPath;  // eg.: "/home/seb/foo.html_files/images/"
	TQString imagesFolderName;  // eg.: "foo.html_files/images/" or "../images/"
	TQString dataFolderPath;    // eg.: "/home/seb/foo.html_files/data/" or "/home/seb/foo.html_files/baskets/basketN-data/"
	TQString dataFolderName;    // eg.: "foo.html_files/data/" or "basketN-data/"
	TQString basketsFolderPath; // eg.: "/home/seb/foo.html_files/baskets/"
	TQString basketsFolderName; // eg.: "foo.html_files/baskets/" or ""

	// Various properties of the currently exporting basket:
	TQString backgroundColorName;

	// Variables used by every export methods:
	TQTextStream stream;
	Basket *exportedBasket;
	bool withBasketTree;
	KProgress *progress;
};

#endif // HTMLEXPORTER_H
