/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef CONTAINER_H
#define CONTAINER_H

#include <tdemainwindow.h>
#include <tqtabbar.h>
#include <tqtabwidget.h>
#include <tqlabel.h>
#include <ksystemtray.h>
#include <tqptrlist.h>
#include <tqpoint.h>
#include <tqclipboard.h>
#include <tdeaction.h>
#include <tqpixmap.h>
#include <tqdesktopwidget.h>
#include <tqtimer.h>
#include <tqsplitter.h>

class TQWidget;
class TQPoint;
class TDEAction;
class TDEToggleAction;
class TQPopupMenu;
class TQSignalMapper;
class TQStringList;
class TQToolTipGroup;
class KPassivePopup;
class Basket;
class DecoratedBasket;
class Container;
class RegionGrabber;
class NoteSelection;
class BNPView;
class ClickableLabel;
namespace KSettings { class Dialog; };


/** The window that contain baskets, organized by tabs.
  * @author S�astien Laot
  */
class MainWindow : public TDEMainWindow
{
  TQ_OBJECT
  
  public:
	/** Construtor, initializer and destructor */
	MainWindow(TQWidget *parent = 0, const char *name = 0);
	~MainWindow();
  private:
	void setupActions();
  public slots:
	bool askForQuit();
	/** Settings **/
//	void toggleToolBar();
	void toggleStatusBar();
	void showShortcutsSettingsDialog();
	void configureToolbars();
	void configureNotifications();
	void showSettingsDialog();
	void minimizeRestore();
	void quit();
	void changeActive();
	void slotNewToolbarConfig();

  protected:
	bool queryExit();
	bool queryClose();
	virtual void resizeEvent(TQResizeEvent*);
	virtual void moveEvent(TQMoveEvent*);
  public:
	void polish();

  private:
	// Settings actions :
//	TDEToggleAction *m_actShowToolbar;
	TDEToggleAction *m_actShowStatusbar;
	TDEAction       *actQuit;
	TDEAction       *actAppConfig;
	TQPtrList<TDEAction> actBasketsList;

  private:
	TQVBoxLayout        *m_layout;
	BNPView            *m_baskets;
	bool                m_startDocked;
	KSettings::Dialog  *m_settings;
	bool                m_quit;
};

#endif // CONTAINER_H
