/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#include "cbookreadwindow.h"
#include "cmodulechooserbar.h"
#include "cbuttons.h"

#include "backend/cswordtreekey.h"

#include "frontend/display/cdisplay.h"
#include "frontend/keychooser/cbooktreechooser.h"
#include "frontend/cprofilewindow.h"
#include "frontend/cbtconfig.h"

#include "util/ctoolclass.h"
#include "util/cresmgr.h"

//TQt includes
#include <tqsplitter.h>

//TDE includes
#include <tdeaction.h>
#include <tdelocale.h>
#include <tdeversion.h>

using namespace Profile;

CBookReadWindow::CBookReadWindow(ListCSwordModuleInfo modules, CMDIArea* parent, const char *name) : CLexiconReadWindow(modules, parent, name) {}

CBookReadWindow::~CBookReadWindow() {}

void CBookReadWindow::applyProfileSettings( CProfileWindow* profileWindow ) {
	CLexiconReadWindow::applyProfileSettings(profileWindow);

	const bool enable = static_cast<bool>( profileWindow->windowSettings() );
	if (enable) {
		m_treeAction->activate();
	}
};

void CBookReadWindow::storeProfileSettings( CProfileWindow* profileWindow ) {
	CLexiconReadWindow::storeProfileSettings(profileWindow);

	//store information about our show tree structure button
	profileWindow->setWindowSettings( static_cast<int>( m_treeAction->isChecked() ) );
};

void CBookReadWindow::initActions() {
	CLexiconReadWindow::initActions();
	//cleanup, not a clean oo-solution
	Q_ASSERT(actionCollection()->action("nextEntry"));
	Q_ASSERT(actionCollection()->action("previousEntry"));
	actionCollection()->action("nextEntry")->setEnabled(false);
	actionCollection()->action("previousEntry")->setEnabled(false);

	m_treeAction = new TDEToggleAction(
					   i18n("Toggle tree view"),
					   CResMgr::displaywindows::bookWindow::toggleTree::icon,
					   CResMgr::displaywindows::bookWindow::toggleTree::accel,
					   this, TQ_SLOT(treeToggled()),
					   actionCollection(), "toggleTree");

	CBTConfig::setupAccelSettings(CBTConfig::bookWindow, actionCollection());
};

void CBookReadWindow::insertKeyboardActions( TDEActionCollection* const a ) {
	new TDEToggleAction(
		i18n("Toggle tree view"),
		CResMgr::displaywindows::bookWindow::toggleTree::icon,
		CResMgr::displaywindows::bookWindow::toggleTree::accel,
		a, "toggleTree");
		
		//  new TDEAction(i18n("Copy reference only"), TDEShortcut(0), a, "copyReferenceOnly");
	new TDEAction(i18n("Copy entry with text"), TDEShortcut(0), a, "copyEntryWithText");
	//  new TDEAction(i18n("Copy selected text"), TDEShortcut(0), a, "copySelectedText");
	new TDEAction(i18n("Save entry as plain text"), TDEShortcut(0), a, "saveEntryAsPlainText");
	new TDEAction(i18n("Save entry as HTML"), TDEShortcut(0), a, "saveEntryAsHTML");
	//   new TDEAction(i18n("Print reference only"), TDEShortcut(0), a, "printReferenceOnly");
	new TDEAction(i18n("Print entry with text"), TDEShortcut(0), a, "printEntryWithText");

}

/** No descriptions */
void CBookReadWindow::initConnections() {
	CLexiconReadWindow::initConnections();

	connect(m_treeChooser, TQ_SIGNAL(keyChanged(CSwordKey*)),
			this, TQ_SLOT(lookup(CSwordKey*)));
	connect(m_treeChooser, TQ_SIGNAL(keyChanged(CSwordKey*)),
			keyChooser(), TQ_SLOT(updateKey(CSwordKey*)));
	connect(keyChooser(), TQ_SIGNAL(keyChanged(CSwordKey*)),
			m_treeChooser, TQ_SLOT(updateKey(CSwordKey*)));
}

/** Init the view */
void CBookReadWindow::initView() {
	TQSplitter* splitter = new TQSplitter(this);

	setMainToolBar( new TDEToolBar(this) );
	addDockWindow(mainToolBar());

	m_treeChooser = new CBookTreeChooser(modules(), key(), splitter);
	setDisplayWidget( CDisplay::createReadInstance(this, splitter) );

	setKeyChooser( CKeyChooser::createInstance(modules(), key(), mainToolBar()) );

	setModuleChooserBar( new CModuleChooserBar(modules(), modules().first()->type(), this) );
	moduleChooserBar()->setButtonLimit(1);
	addDockWindow( moduleChooserBar() );

	setButtonsToolBar( new TDEToolBar(this) );
	addDockWindow( buttonsToolBar() );
	setDisplaySettingsButton( new CDisplaySettingsButton( &displayOptions(), &filterOptions(), modules(), buttonsToolBar()) );

	m_treeChooser->hide();

	splitter->setResizeMode(m_treeChooser, TQSplitter::Stretch);
	setCentralWidget( splitter );
	setIcon(CToolClass::getIconForModule(modules().first()));
}

void CBookReadWindow::initToolbars() {
	Q_ASSERT(m_treeAction);
	Q_ASSERT(m_actions.backInHistory);

	m_actions.backInHistory->plug( mainToolBar(), 0 );
	m_actions.forwardInHistory->plug( mainToolBar(), 1 );

	mainToolBar()->insertWidget(0,keyChooser()->sizeHint().width(),keyChooser());

	m_treeAction->plug(buttonsToolBar());
	m_treeAction->setChecked(false);

	buttonsToolBar()->insertWidget(2,displaySettingsButton()->size().width(),displaySettingsButton());

	TDEAction* action = actionCollection()->action(
						  CResMgr::displaywindows::general::search::actionName );
	if (action) {
		action->plug(buttonsToolBar());
	}

	#if TDE_VERSION_MINOR < 1
	action->plugAccel( accel() );
	#endif
}

/** Is called when the action was executed to toggle the tree view. */
void CBookReadWindow::treeToggled() {
	if (m_treeAction->isChecked()) {
		m_treeChooser->show();
	}
	else {
		m_treeChooser->hide();
	}
}

/** Reimplementation to take care of the tree chooser. */
void CBookReadWindow::modulesChanged() {
	CLexiconReadWindow::modulesChanged();
	m_treeChooser->setModules(modules());
	lookup(key());
}

void CBookReadWindow::setupPopupMenu() {
	CLexiconReadWindow::setupPopupMenu();

	popup()->changeTitle(-1, CToolClass::getIconForModule(modules().first()), i18n("Book window"));
}

#include "cbookreadwindow.moc"
