/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CSCROLLERWIDGETSET_H
#define CSCROLLERWIDGETSET_H

#include <tqwidget.h>
#include <tqmap.h>
#include <tqstringlist.h>
#include <tqlayout.h>
#include <tqlayout.h>

#include <kcombobox.h>
#include "cscrollbutton.h"

/**
 * This class implements the Scroller Widget-set, which
 * consists of two normal ref @TQToolButton and a enhanced @ref CScrollButton
 *
  * @author The BibleTime team
  */
class CScrollerWidgetSet : public TQWidget {
	TQ_OBJECT
  
public:
	/**
	* the constructor
	*/
	CScrollerWidgetSet(TQWidget *parent=0, const char *name=0);
	/**
	* Sets the tooltips for the given entries using the parameters as text.
	*/
	void setToolTips( const TQString nextEntry, const TQString scrollButton, const TQString previousEntry);

signals:
	/**
	* is emitted to proceed to some other entry relative to the 
	* current, indicated by the int value
	*/
	void change(int count);

	/**
	* These emit when the scroll button is pressed or released
	*/
	void scroller_pressed();
	void scroller_released();

protected:
	TQToolButton* btn_up;
	TQToolButton* btn_down;
	CScrollButton* btn_fx;

protected slots:
	void slotLock();
	void slotUnlock();
	void slotUpClick();
	void slotDownClick();
	void slotScroller(int);

private:
	TQVBoxLayout *m_layout;

};

#endif
