/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-01-15
 * Description : digiKam TDEIO slave to get image thumbnails.
 *
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2003-2009 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef _digikamthumbnail_H_
#define _digikamthumbnail_H_

// KDE includes.

#include <tdeio/slavebase.h>

class TQString;
class TQImage;
class TQApplication;

class KURL;

class tdeio_digikamthumbnailProtocol : public TDEIO::SlaveBase
{

public:

    tdeio_digikamthumbnailProtocol(int argc, char** argv);
    virtual ~tdeio_digikamthumbnailProtocol();
    virtual void get(const KURL& url);

private:

    bool   loadByExtension(TQImage& image, const TQString& path);
    bool   loadJPEG(TQImage& image, const TQString& path);
    void   exifRotate(const TQString& filePath, TQImage& thumb);
    TQImage loadPNG(const TQString& path);
    bool   loadDImg(TQImage& image, const TQString& path);
    bool   loadKDEThumbCreator(TQImage& image, const TQString& path);
    void   createThumbnailDirs();

private:

    int           cachedSize_;

    int           org_width_;
    int           org_height_;
    int           new_width_;
    int           new_height_;

    int           argc_;
    char        **argv_;

    TQString       digiKamFingerPrint;
    TQString       smallThumbPath_;
    TQString       bigThumbPath_;

    TQApplication *app_;
};

#endif  // _digikamthumbnail_H_
