/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2003-01-29
 * Description : Camera settings container.
 * 
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef CAMERATYPE_H
#define CAMERATYPE_H

// TQt includes.

#include <tqstring.h>
#include <tqdatetime.h>
#include <tqguardedptr.h>

class TDEAction;

namespace Digikam
{

class CameraUI;
class CameraTypePrivate;

class CameraType
{
public:


    CameraType();
    CameraType(const TQString& title, const TQString& model,
               const TQString& port, const TQString& path,
               const TQDateTime& lastAccess, TDEAction* action=0);
    ~CameraType();

    CameraType(const CameraType& ctype);
    CameraType& operator=(const CameraType& type);

    void setTitle(const TQString& title);
    void setModel(const TQString& model);
    void setPort(const TQString& port);
    void setPath(const TQString& path);
    void setLastAccess(const TQDateTime& lastAccess);
    void setAction(TDEAction *action);
    void setValid(bool valid);
    void setCurrentCameraUI(CameraUI *cameraui);

    TQString   title()           const;
    TQString   model()           const;
    TQString   port()            const;
    TQString   path()            const;
    TQDateTime lastAccess()      const;
    TDEAction*  action()          const;
    bool      valid()           const;
    CameraUI *currentCameraUI() const;

private:

    CameraTypePrivate *d;
};

}  // namespace Digikam

#endif /* CAMERATYPE_H */
