/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-31-01
 * Description : main digiKam interface implementation
 *
 * Copyright (C) 2007-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqcstring.h>
#include <tqstring.h>
#include <tqmap.h>
#include <tqtoolbutton.h>
#include <tqtimer.h>

// KDE includes.

#include <tdeconfig.h>
#include <tdeaction.h>
#include <tdeaccel.h>
#include <tdepopupmenu.h>
#include <kstatusbar.h>

// libKipi includes.

#include <libkipi/pluginloader.h>

// Local includes.

#include "albummanager.h"
#include "albumsettings.h"
#include "cameralist.h"
#include "imagepluginloader.h"
#include "splashscreen.h"
#include "kipiinterface.h"
#include "statuszoombar.h"
#include "statusprogressbar.h"
#include "statusnavigatebar.h"
#include "digikamview.h"

class TDEToolBarPopupAction;
class TDEToggleAction;
class TDEActionMenu;
class TDESelectAction;

namespace Digikam
{

class DCOPIface;
class SearchTextBar;
class AlbumIconViewFilter;

class DigikamAppPriv
{
public:

    DigikamAppPriv()
    {
        fullScreen                           = false;
        validIccPath                         = true;
        cameraMediaList                      = 0;
        accelerators                         = 0;
        config                               = 0;
        newAction                            = 0;
        deleteAction                         = 0;
        imageDeletePermanentlyAction         = 0;
        imageDeletePermanentlyDirectlyAction = 0;
        imageTrashDirectlyAction             = 0;
        albumSortAction                      = 0;
        recurseAlbumsAction                  = 0;
        recurseTagsAction                    = 0;
        backwardActionMenu                   = 0;
        forwardActionMenu                    = 0;
        addImagesAction                      = 0;
        propsEditAction                      = 0;
        albumImportAction                    = 0;
        openInKonquiAction                   = 0;
        refreshAlbumAction                   = 0;
        syncAlbumMetadataAction              = 0;
        newTagAction                         = 0;
        deleteTagAction                      = 0;
        editTagAction                        = 0;
        imagePreviewAction                   = 0;
        imageViewAction                      = 0;
        imageLightTableAction                = 0;
        imageAddLightTableAction             = 0;
        imageSetExifOrientation1Action       = 0;
        imageSetExifOrientation2Action       = 0;
        imageSetExifOrientation3Action       = 0;
        imageSetExifOrientation4Action       = 0;
        imageSetExifOrientation5Action       = 0;
        imageSetExifOrientation6Action       = 0;
        imageSetExifOrientation7Action       = 0;
        imageSetExifOrientation8Action       = 0;
        imageRenameAction                    = 0;
        imageDeleteAction                    = 0;
        imageSortAction                      = 0;
        imageExifOrientationActionMenu       = 0;
        selectAllAction                      = 0;
        selectNoneAction                     = 0;
        selectInvertAction                   = 0;
        fullScreenAction                     = 0;
        slideShowAction                      = 0;
        slideShowAllAction                   = 0;
        slideShowSelectionAction             = 0;
        slideShowRecursiveAction             = 0;
        rating0Star                          = 0;
        rating1Star                          = 0;
        rating2Star                          = 0;
        rating3Star                          = 0;
        rating4Star                          = 0;
        rating5Star                          = 0;
        quitAction                           = 0;
        tipAction                            = 0;
        rawCameraListAction                  = 0;
        kipiHelpAction                       = 0;
        donateMoneyAction                    = 0;
        cameraMenuAction                     = 0;
        themeMenuAction                      = 0;
        albumSettings                        = 0;
        albumManager                         = 0;
        dcopIface                            = 0;
        imagePluginsLoader                   = 0;
        kipiInterface                        = 0;
        cameraList                           = 0;
        statusProgressBar                    = 0;
        statusNavigateBar                    = 0;
        statusZoomBar                        = 0;
        kipiPluginLoader                     = 0;
        view                                 = 0;
        splashScreen                         = 0;
        zoomTo100percents                    = 0;
        zoomFitToWindowAction                = 0;
        zoomPlusAction                       = 0;
        zoomMinusAction                      = 0;
        albumIconViewFilter                  = 0;
        contributeAction                     = 0;
        showMenuBarAction                    = 0;
    }

    bool                   fullScreen;
    bool                   validIccPath;

    // KIPI plugins support
    TQPtrList<TDEAction>      kipiFileActionsExport;
    TQPtrList<TDEAction>      kipiFileActionsImport;
    TQPtrList<TDEAction>      kipiImageActions;
    TQPtrList<TDEAction>      kipiToolsActions;
    TQPtrList<TDEAction>      kipiBatchActions;
    TQPtrList<TDEAction>      kipiAlbumActions;

    TQMap<int, TQString>     mediaItems;

    TQString                cameraGuiPath;

    TDEPopupMenu            *cameraMediaList;

    TDEAccel                *accelerators;

    TDEConfig               *config;

    // Album Actions
    TDEAction               *newAction;
    TDEAction               *deleteAction;
    TDEAction               *imageDeletePermanentlyAction;
    TDEAction               *imageDeletePermanentlyDirectlyAction;
    TDEAction               *imageTrashDirectlyAction;
    TDEToolBarPopupAction   *backwardActionMenu;
    TDEToolBarPopupAction   *forwardActionMenu;

    TDEAction               *addImagesAction;
    TDEAction               *propsEditAction;
    TDEAction               *albumImportAction;
    TDEAction               *openInKonquiAction;
    TDEAction               *refreshAlbumAction;
    TDEAction               *syncAlbumMetadataAction;

    // Tag Actions
    TDEAction               *newTagAction;
    TDEAction               *deleteTagAction;
    TDEAction               *editTagAction;

    // Image Actions
    TDEToggleAction         *imagePreviewAction;
    TDEAction               *imageLightTableAction;
    TDEAction               *imageAddLightTableAction;
    TDEAction               *imageViewAction;
    TDEAction               *imageSetExifOrientation1Action;
    TDEAction               *imageSetExifOrientation2Action;
    TDEAction               *imageSetExifOrientation3Action;
    TDEAction               *imageSetExifOrientation4Action;
    TDEAction               *imageSetExifOrientation5Action;
    TDEAction               *imageSetExifOrientation6Action;
    TDEAction               *imageSetExifOrientation7Action;
    TDEAction               *imageSetExifOrientation8Action;
    TDEAction               *imageRenameAction;
    TDEAction               *imageDeleteAction;
    TDEActionMenu           *imageExifOrientationActionMenu;

    // Selection Actions
    TDEAction               *selectAllAction;
    TDEAction               *selectNoneAction;
    TDEAction               *selectInvertAction;

    // View Actions
    TDEToggleAction         *fullScreenAction;
    TDEToggleAction         *showMenuBarAction;
    TDEActionMenu           *slideShowAction;
    TDEAction               *slideShowAllAction;
    TDEAction               *slideShowSelectionAction;
    TDEAction               *slideShowRecursiveAction;
    TDESelectAction         *imageSortAction;
    TDESelectAction         *albumSortAction;
    TDEToggleAction         *recurseAlbumsAction;
    TDEToggleAction         *recurseTagsAction;
    TDEAction               *zoomPlusAction;
    TDEAction               *zoomMinusAction;
    TDEAction               *zoomFitToWindowAction;
    TDEAction               *zoomTo100percents;

    TDEAction               *rating0Star;
    TDEAction               *rating1Star;
    TDEAction               *rating2Star;
    TDEAction               *rating3Star;
    TDEAction               *rating4Star;
    TDEAction               *rating5Star;

    // Application Actions
    TDEAction               *rawCameraListAction;
    TDEAction               *quitAction;
    TDEAction               *tipAction;
    TDEAction               *kipiHelpAction;
    TDEAction               *donateMoneyAction;
    TDEAction               *contributeAction;
    TDEActionMenu           *cameraMenuAction;
    TDESelectAction         *themeMenuAction;

    AlbumSettings         *albumSettings;
    AlbumManager          *albumManager;
    AlbumIconViewFilter   *albumIconViewFilter;
    SplashScreen          *splashScreen;
    DCOPIface             *dcopIface;
    ImagePluginLoader     *imagePluginsLoader;
    DigikamKipiInterface  *kipiInterface;
    DigikamView           *view;
    CameraList            *cameraList;
    StatusZoomBar         *statusZoomBar;
    StatusProgressBar     *statusProgressBar;
    StatusNavigateBar     *statusNavigateBar;
    KIPI::PluginLoader    *kipiPluginLoader;
};

}  // namespace Digikam
