#ifndef tdegtk_animations_h
#define tdegtk_animations_h

/*
* this file was largely taken from the oxygen gtk engine
* Copyright (c) 2010 Hugo Pereira Da Costa <hugo@oxygen-icons.org>
*
* This  library is free  software; you can  redistribute it and/or
* modify it  under  the terms  of the  GNU Lesser  General  Public
* License  as published  by the Free  Software  Foundation; either
* version 2 of the License, or(at your option ) any later version.
*
* This library is distributed  in the hope that it will be useful,
* but  WITHOUT ANY WARRANTY; without even  the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License  along  with  this library;  if not,  write to  the Free
* Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
* MA 02110-1301, USA.
*/

// #include "tdegtk-arrowstateengine.h"
// #include "tdegtk-backgroundhintengine.h"
#include "tdegtk-baseengine.h"
// #include "tdegtk-comboboxengine.h"
// #include "tdegtk-comboboxentryengine.h"
// #include "tdegtk-dialogengine.h"
// #include "tdegtk-groupboxengine.h"
// #include "tdegtk-groupboxlabelengine.h"
#include "tdegtk-hooks.h"
// #include "tdegtk-hoverengine.h"
// #include "tdegtk-mainwindowengine.h"
// #include "tdegtk-menubarstateengine.h"
// #include "tdegtk-menuitemengine.h"
// #include "tdegtk-menustateengine.h"
// #include "tdegtk-panedengine.h"
// #include "tdegtk-scrollbarengine.h"
// #include "tdegtk-scrollbarstateengine.h"
// #include "tdegtk-scrolledwindowengine.h"
// #include "tdegtk-innershadowengine.h"
#include "tdegtk-signals.h"
#include "tdegtk-tabwidgetengine.h"
// #include "tdegtk-tabwidgetstateengine.h"
// #include "tdegtk-toolbarstateengine.h"
// #include "tdegtk-treeviewengine.h"
// #include "tdegtk-treeviewstateengine.h"
// #include "tdegtk-widgetsizeengine.h"
// #include "tdegtk-widgetstateengine.h"

#include <gtk/gtk.h>
#include <vector>
#include <map>

    //! keeps track of all animation engines
    class Animations
    {

        public:

        //! constructor
        Animations( void );

        //! destructor
        virtual ~Animations( void );

        //! initialize settings
//         void initialize( const QtSettings& );

        //! initialize hooks
        void initializeHooks( void );

        //! unregister widget
        bool registerWidget( GtkWidget* );

        //! unregister widget
        void unregisterWidget( GtkWidget* );

        //! enabled state
        void setEnabled( bool value );

#if 0
        //! inner shadow enabled state
        void setInnerShadowsEnabled( bool value )
        { _innerShadowsEnabled = value; }

        //! inner shadow enabled state
        bool innerShadowsEnabled( void ) const
        { return _innerShadowsEnabled; }

        //! combobox engine
        ComboBoxEngine& comboBoxEngine( void ) const
        { return *_comboBoxEngine; }

        //! comboboxentry engine
        ComboBoxEntryEngine& comboBoxEntryEngine( void ) const
        { return *_comboBoxEntryEngine; }

        //! dialog engine
        DialogEngine& dialogEngine( void ) const
        { return *_dialogEngine; }

        //! groupbox engine
        GroupBoxEngine& groupBoxEngine( void ) const
        { return *_groupBoxEngine; }

        //! background hint
        BackgroundHintEngine& backgroundHintEngine( void ) const
        { return *_backgroundHintEngine; }

        //! main window engine
        MainWindowEngine& mainWindowEngine( void ) const
        { return *_mainWindowEngine; }

        //! menu item engine
        MenuItemEngine& menuItemEngine( void ) const
        { return *_menuItemEngine; }

        //! hover engine
        HoverEngine& hoverEngine( void ) const
        { return *_hoverEngine; }

        //! paned (splitter) engine
        PanedEngine& panedEngine( void ) const
        { return *_panedEngine; }

        //! scrollbar engine
        ScrollBarEngine& scrollBarEngine( void ) const
        { return *_scrollBarEngine; }

        //! scrolled window engine
        ScrolledWindowEngine& scrolledWindowEngine( void ) const
        { return *_scrolledWindowEngine; }

        //! inner shadow engine
        InnerShadowEngine& innerShadowEngine( void ) const
        { return *_innerShadowEngine; }
#endif

        //! tab widget engine
        TabWidgetEngine& tabWidgetEngine( void ) const
        { return *_tabWidgetEngine; }

#if 0
        //! tree view engine
        TreeViewEngine& treeViewEngine( void ) const
        { return *_treeViewEngine; }

        //! window size engine
        WidgetSizeEngine& widgetSizeEngine( void ) const
        { return *_widgetSizeEngine; }

        //!@name animations specific engines
        //@{

        //! widget mouse-over and focus animations engine
        WidgetStateEngine& widgetStateEngine( void ) const
        { return *_widgetStateEngine; }

        //! arrow mouse-over animations engine
        ArrowStateEngine& arrowStateEngine( void ) const
        { return *_arrowStateEngine; }

        //! scrollbar arrow mouse-over animations engine
        ScrollBarStateEngine& scrollBarStateEngine( void ) const
        { return *_scrollBarStateEngine; }

        //! notebook tabs mouse-over animations engine
        TabWidgetStateEngine& tabWidgetStateEngine( void ) const
        { return *_tabWidgetStateEngine; }

        //! tree view mouse-over animation engine
        TreeViewStateEngine& treeViewStateEngine( void ) const
        { return *_treeViewStateEngine; }

        //! menubar mouse-over animation engine
        MenuBarStateEngine& menuBarStateEngine( void ) const
        { return *_menuBarStateEngine; }

        //! menu mouse-over animation engine
        MenuStateEngine& menuStateEngine( void ) const
        { return *_menuStateEngine; }

        //! toolbar mouse-over animation engine
        ToolBarStateEngine& toolBarStateEngine( void ) const
        { return *_toolBarStateEngine; }
#endif

        //@}

        protected:

        //! register new engine
        void registerEngine( BaseEngine* engine )
        { _engines.push_back( engine ); }

#if 0
        //! groupbox engine
        GroupBoxLabelEngine& groupBoxLabelEngine( void ) const
        { return *_groupBoxLabelEngine; }
#endif

        //! destruction callback
        static gboolean destroyNotifyEvent( GtkWidget*, gpointer );

        //! combobox list size adjustment hook
        static gboolean sizeAllocationHook( GSignalInvocationHint*, guint, const GValue*, gpointer );

#if 0
        //! background hint setting hook
        static gboolean backgroundHintHook( GSignalInvocationHint*, guint, const GValue*, gpointer );

        //! inner shadow composited mode enabling hook
        static gboolean innerShadowHook( GSignalInvocationHint*, guint, const GValue*, gpointer );
#endif

        //! widget realize hook
        static gboolean realizationHook( GSignalInvocationHint*, guint, const GValue*, gpointer );

        private:

        //! inner shadow enabled state
        bool _innerShadowsEnabled;

        //! list of engines
        BaseEngine::List _engines;

#if 0
        //! background hint engine
        BackgroundHintEngine* _backgroundHintEngine;

        //! combobox engine
        ComboBoxEngine* _comboBoxEngine;

        //! combobox entry engine
        ComboBoxEntryEngine* _comboBoxEntryEngine;

        //! dialog engine
        DialogEngine* _dialogEngine;

        //! groupbox engine
        GroupBoxEngine* _groupBoxEngine;

        //! groupbox engine
        GroupBoxLabelEngine* _groupBoxLabelEngine;

        //! hover engine
        HoverEngine* _hoverEngine;

        //! main window engine
        MainWindowEngine* _mainWindowEngine;

        //! menu item engine
        MenuItemEngine* _menuItemEngine;

        //! paned engine
        PanedEngine* _panedEngine;

        //! scrollbar engine
        ScrollBarEngine* _scrollBarEngine;

        //! scrolled window engine
        ScrolledWindowEngine* _scrolledWindowEngine;

        //! inner shadow engine
        InnerShadowEngine* _innerShadowEngine;
#endif

        //! tab widget engine
        TabWidgetEngine* _tabWidgetEngine;

#if 0
        //! tree view engine
        TreeViewEngine* _treeViewEngine;

        //! widget size engine
        WidgetSizeEngine* _widgetSizeEngine;

        //!@name Animation specific engines
        //@{

        //! widget mouse-over and focus animations engine
        WidgetStateEngine* _widgetStateEngine;

        //! arrow mouse-over animations engine
        ArrowStateEngine* _arrowStateEngine;

        //! scrollbar arrow mouse-over animations engine
        ScrollBarStateEngine* _scrollBarStateEngine;

        //! notebook tabs mouse-over animations engine
        TabWidgetStateEngine* _tabWidgetStateEngine;

        //! tree view mouse-over animation engine
        TreeViewStateEngine* _treeViewStateEngine;

        //! menubar mouse-over animation engine
        MenuBarStateEngine* _menuBarStateEngine;

        //! menu mouse-over animation engine
        MenuStateEngine* _menuStateEngine;

        //! toolbar mouse-over animation engine
        ToolBarStateEngine* _toolBarStateEngine;
#endif

        //@}

        //!@name hooks
        //@{

        //! true when hooks are initialized
        bool _hooksInitialized;

        //! realization hook
        Hook _realizationHook;

        //! size allocation hook
        Hook _sizeAllocationHook;

        //! background hint hook
        Hook _backgroundHintHook;

        //! inner shadows hook
        Hook _innerShadowHook;

        //@}

        //! keep track of all registered widgets, and associated destroy callback
        typedef std::map< GtkWidget*, Signal > WidgetMap;
        WidgetMap _allWidgets;

    };

#endif

