/***************************************************************************
                          barcodedialogs.h  -  description
                             -------------------
    begin                : Fre Sep 5 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BARCODEDIALOGS_H
#define BARCODEDIALOGS_H

#include <tqmap.h>
#include <tqptrlist.h>
#include <tqwidget.h>
#include <tqvbox.h>
#include <kdialogbase.h>

class Barkode;
class KColorButton;
class KComboBox;
class KDoubleNumInput;
class KIntNumInput;
class TQCheckBox;
class TQRadioButton;

/** A base class for all widgets, that will be used in AdvancedBarcodeDialog
  * to modify the settings of a barcode. The API is simple. You can only set the
  * current barcode settings and retrieve them after the user modified them.
  *
  * @author Dominik Seichter
  */
class BarcodeDlgBase {
    public:
        virtual void setData( Barkode* b ) = 0;
        virtual void getData( Barkode* b ) const = 0;
};

/**
  * A configuration dialog for advanced barcode settings.
  * Used in BarcodeWidget. It loads the wigets below into tabs.
  * @see TBarcodeDlg
  * @see PDF417BarcodeDlg
  * @see DataMatrixDlg
  * @seeSequenceDlg
  *
  * @author Dominik Seichter
  */
class AdvancedBarcodeDialog : public KDialogBase {
    TQ_OBJECT
  
    public:
        AdvancedBarcodeDialog( TQString type, TQWidget* parent = 0, const char* name = 0 );
        ~AdvancedBarcodeDialog();

        void setData( Barkode* b );
        void getData( Barkode* b );

    private:
        TQPtrList<BarcodeDlgBase> list;
};

/** A configuration widget for TBarcode settings.
  * @author Dominik Seichter
  */
class TBarcodeDlg : public TQWidget, public BarcodeDlgBase {
   TQ_OBJECT
  
    public: 
        TBarcodeDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;

    private:
        KDoubleNumInput* spinModule;
        KIntNumInput* spinHeight;
        TQCheckBox* checkEscape;
        TQCheckBox* checkAbove;
        TQCheckBox* checkAutoCorrect;
        KComboBox* comboCheckSum;

        TQMap<TQString,int> map;
};

/** A configuration Dialog for PDF417 settings.
  * @author Dominik Seichter
  */
class PDF417BarcodeDlg : public TQWidget, public BarcodeDlgBase {
   TQ_OBJECT
  
    public:
        PDF417BarcodeDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;
        
    private:
        KIntNumInput* spinRow;
        KIntNumInput* spinCol;
        KIntNumInput* spinErr;
};

/** A configuration widget for DataMatrix settings.
  * @author Dominik Seichter
  */
class DataMatrixDlg : public TQWidget, public BarcodeDlgBase {
   TQ_OBJECT
  
    public:
        DataMatrixDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;
        
    private:
        KComboBox* comboDataMatrix;
};

/** A configuration widget for barcode sequences.
  * @author Dominik Seichter
  */
class SequenceDlg : public TQWidget, public BarcodeDlgBase {
    TQ_OBJECT
  
    public:
        SequenceDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;

    private slots:
        void enableControls();
        
    private:
        TQCheckBox* checkSequence;
        TQRadioButton* radioNumbers;
        TQRadioButton* radioAlpha;
        TQRadioButton* radioAlphaNum;

        KIntNumInput* spinStep;
        KIntNumInput* spinStart;
};

/** A configuration widget for colors in pure postscript barcodes
  * @author Dominik Seichter
  */
class ColorDlg : public TQVBox, public BarcodeDlgBase {
    TQ_OBJECT
  
    public:
        ColorDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;

    private:
        KColorButton* buttonBarColor;
        KColorButton* buttonBackColor;
        KColorButton* buttonTextColor;
};

/** A configuration widget for colors in pure postscript barcodes
  * @author Dominik Seichter
  */
class PurePostscriptDlg : public TQVBox, public BarcodeDlgBase {
    TQ_OBJECT
  
    public:
        PurePostscriptDlg(TQWidget *parent=0, const char *name=0);

        void setData( Barkode* b );
        void getData( Barkode* b ) const;

    private:
        TQCheckBox* checkChecksum;
};

#endif
