/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <kiconloader.h>
#include <tdelocale.h>

#include "entrywidgetwarningsitem.h"

namespace KBibTeX
{

    EntryWidgetWarningsItem::EntryWidgetWarningsItem( WarningLevel level, const TQString &message, TQWidget *widget, TQListView *parent, const char* name )
            : TQListViewItem( parent, name ), m_widget( widget )
    {
        TDEIconLoader * loader = TDEGlobal::instance() ->iconLoader();
        switch ( level )
        {
        case wlInformation:
            setPixmap( 0, loader->loadIcon( "messagebox_info", TDEIcon::NoGroup, TDEIcon::SizeSmall ) );
            break;
        case wlWarning:
            setPixmap( 0, loader->loadIcon( "messagebox_warning", TDEIcon::NoGroup, TDEIcon::SizeSmall ) );
            break;
        case wlError:
            setPixmap( 0, loader->loadIcon( "messagebox_critical", TDEIcon::NoGroup, TDEIcon::SizeSmall ) );
            break;
        default:
            {
                // nothing
            }
        }
        setText( 0, message );
    }


    EntryWidgetWarningsItem::~EntryWidgetWarningsItem()
    {
        // nothing
    }

    TQWidget *EntryWidgetWarningsItem::widget()
    {
        return m_widget;
    }

}
