/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXVALUE_H
#define BIBTEXVALUE_H

#include <tqvaluelist.h>

class TQStringList;

namespace BibTeX
{
    class ValueTextInterface
    {
    public:
        ValueTextInterface( const ValueTextInterface* other );
        ValueTextInterface( const TQString& text );
        virtual ~ValueTextInterface() {};

        virtual void setText( const TQString& text );
        virtual TQString text() const;
        TQString simplifiedText() const;
        virtual void replace( const TQString &before, const TQString &after );
        virtual bool containsPattern( const TQString &pattern, bool caseSensitive );

    private:
        TQString m_text;
    };

    class ValueItem: public ValueTextInterface
    {
    public:
        ValueItem( const TQString& text );

        virtual ValueItem *clone()
        {
            return NULL;
        };
    };

    class Keyword: public ValueTextInterface
    {
    public:
        Keyword( Keyword *other );
        Keyword( const TQString& text );

        Keyword *clone();
    };

    class KeywordContainer: public ValueItem
    {
    public:
        KeywordContainer();
        KeywordContainer( const TQString& text );
        KeywordContainer( KeywordContainer *other );
        KeywordContainer( const TQStringList& list );

        ValueItem *clone();
        void setList( const TQStringList& list );
        void append( const TQString& text );
        void remove( const TQString& text );
        void setText( const TQString& text );
        TQString text() const;
        void replace( const TQString &before, const TQString &after );

        TQValueList<Keyword*> keywords;
    };

    class Person: public ValueTextInterface
    {
    public:
        Person( const TQString& text, bool firstNameFirst = false );
        Person( const TQString& firstName, const TQString& lastName, bool firstNameFirst = false );

        Person *clone();
        void setText( const TQString& text );
        TQString text() const;
        TQString text( bool firstNameFirst ) const;

        TQString firstName();
        TQString lastName();

    protected:
        TQString m_firstName;
        TQString m_lastName;
        bool m_firstNameFirst;

        bool splitName( const TQString& text, TQStringList& segments );
    };

    class PersonContainer: public ValueItem
    {
    public:
        PersonContainer( bool firstNameFirst = false );
        PersonContainer( const TQString& text, bool firstNameFirst = false );

        ValueItem *clone();
        void setText( const TQString& text );
        TQString text() const;
        void replace( const TQString &before, const TQString &after );

        TQValueList<Person*> persons;

    private:
        bool m_firstNameFirst;
    };

    class MacroKey: public ValueItem
    {
    private:
        bool m_isValid;
        bool isValidInternal();

    public:
        MacroKey( const TQString& text );

        ValueItem *clone();

        void setText( const TQString& text );
        bool isValid();
    };

    class PlainText: public ValueItem
    {
    public:
        PlainText( const TQString& text );

        ValueItem *clone();
    };

    class Value: public ValueTextInterface
    {
    public:
        Value();
        Value( const Value *other );
        Value( const TQString& text, bool isMacroKey = false );

        void setText( const TQString& text );
        TQString text() const;
        void replace( const TQString &before, const TQString &after );

        TQValueList<ValueItem*> items;
    };
}

#endif
