/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef MEMWINDOW_H
#define MEMWINDOW_H

#include <tqpopupmenu.h>
#include <tqlistview.h>
#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqmap.h>
#include "dbgdriver.h"

class KDebugger;
class TDEConfigBase;

class MemoryWindow : public TQWidget
{
    TQ_OBJECT
public:
    MemoryWindow(TQWidget* parent, const char* name);
    ~MemoryWindow();

    void setDebugger(KDebugger* deb) { m_debugger = deb; }

protected:
    KDebugger* m_debugger;
    TQComboBox m_expression;

    TQListView m_memory;
    TQMap<TQString,TQString> m_old_memory;

    TQVBoxLayout m_layout;

    unsigned m_format;
    TQMap<TQString,unsigned> m_formatCache;

    TQPopupMenu m_popup;

    virtual bool eventFilter(TQObject* o, TQEvent* ev);
    void handlePopup(TQMouseEvent* ev);
    void displayNewExpression(const TQString& expr);

public slots:
    void slotNewExpression(const TQString&);
    void slotTypeChange(int id);
    void slotNewMemoryDump(const TQString&, const std::list<MemoryDump>&);
    void saveProgramSpecific(TDEConfigBase* config);
    void restoreProgramSpecific(TDEConfigBase* config);
};

#endif // MEMWINDOW_H
