/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef PREFDEBUGGER_H
#define PREFDEBUGGER_H

#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqlabel.h>

class PrefDebugger : public TQWidget
{
public:
    PrefDebugger(TQWidget* parent);

    TQGridLayout m_grid;

    // --- the hint about defaults
protected:
    TQLabel m_defaultHint;

    // --- the debugger command
protected:
    TQLabel m_debuggerCCppLabel;
    TQLineEdit m_debuggerCCpp;
public:
    TQString debuggerCmd() const { return m_debuggerCCpp.text(); }
    void setDebuggerCmd(const TQString& cmd) { m_debuggerCCpp.setText(cmd); }

    // --- the output terminal
protected:
    TQLabel m_terminalHint;
    TQLabel m_terminalLabel;
    TQLineEdit m_terminal;
public:
    TQString terminal() const { return m_terminal.text(); }
    void setTerminal(const TQString& t) { m_terminal.setText(t); }
};

#endif // PREFDEBUGGER_H
