###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


##### Look for glib2

pkg_search_module( GLIB2 glib-2.0 )
if( NOT GLIB2_FOUND )
    tde_message_fatal( "glib-2.0 is required, but was not found on your system" )
endif( NOT GLIB2_FOUND )


##### check for koffice includes

if( NOT DEFINED KOFFICE_INCLUDE_DIR )
    message( STATUS "Checking for KOffice includes" )
    find_path( KOFFICE_INCLUDE_DIR
        NAMES kofficeversion.h
        HINTS ${TDE_INCLUDE_DIR} ${TDE_INCLUDE_DIR}/tde
    )
    if( "${KOFFICE_INCLUDE_DIR}" STREQUAL "KOFFICE_INCLUDE_DIR-NOTFOUND" )
        tde_message_fatal( "KOffice includes are required, but was not found on your system" )
    endif( )
    message( STATUS "Checking for KOffice includes - found ${KOFFICE_INCLUDE_DIR}" )
endif( )
