/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2006 by the KFTPGrabber developers
 * Copyright (C) 2003-2006 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPENGINESFTPSOCKET_H
#define KFTPENGINESFTPSOCKET_H

// LibSSH includes
#include "misc/libs/ssh/libssh.h"
#include "misc/libs/ssh/sftp.h"

#include "socket.h"

namespace KFTPEngine {

/**
 * @author Jernej Kos <kostko@jweb-network.net>
 */
class SftpSocket : public Socket {
friend class SftpCommandConnect;
friend class SftpCommandList;
friend class SftpCommandGet;
friend class SftpCommandPut;
public:
    SftpSocket(Thread *thread);
    ~SftpSocket();
    
    void protoConnect(const KURL &url);
    void protoDisconnect();
    void protoAbort();
    void protoGet(const KURL &source, const KURL &destination);
    void protoPut(const KURL &source, const KURL &destination);
    void protoRemove(const KURL &path);
    void protoRename(const KURL &source, const KURL &destination);
    void protoChmodSingle(const KURL &path, int mode);
    void protoMkdir(const KURL &path);
    void protoList(const KURL &path);
    
    void poll() {};
    
    int features() { return 0; }
    
    bool isConnected() { return m_login; }
    bool isEncrypted() { return true; }
    
    SSH_SESSION *sshSession() { return m_sshSession; }
    SFTP_SESSION *sftpSession() { return m_sftpSession; }
private:
    TQString posixToString(int permissions);
    int intToPosix(int permissions);
private:
    SSH_SESSION *m_sshSession;
    SFTP_SESSION *m_sftpSession;
    
    bool m_login;
};

}

#endif
