/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef MISC_H
#define MISC_H

#include <tqiconset.h>
#include <tqptrlist.h>

#include <kiconloader.h>

class KURL;
class TDEConfig;

namespace KFTPGrabberBase {
  // Icon loading stuff
  TQPixmap loadPanelPixmap(const TQString &name);
  TQIconSet loadToolbarIcon(const TQString &name, int state = 0);
  TQIconSet loadSmallIcon(const TQString &name, int state = 0);
  TQPixmap loadToolbarPixmap(const TQString &name);
  TQPixmap loadSmallPixmap(const TQString &name);

  // Other stuff
  TQPixmap createColorPixmap(TQString color);
  TQPixmap createProgressPixmap(int progress, int current = 0);
  TQString appendPath(const TQString &path, const TQString &what);
  TQString path2Name(const TQString &path);
  TQString path2Dir(const TQString &path);
  bool isModifierKeysPressed(unsigned int mask);
  TQString genID();
  TQString getStoreDir(const TQString &filename = 0);
  
  TDEConfig *config(const TQString &section);
  KURL remoteUrl(const TQString &path, KURL url);

  // For "safer" password storage
  TQString encodePassword(const TQString& password);
  TQString decodePassword(const TQString& password);
}

#endif

