/***************************************************************************
    begin                : sam jui 13 09:50:06 CEST 2002
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : wijnhout@science.uva.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILE_H
#define KILE_H

#include <tdeversion.h>
#include <kate/view.h>
#include <kate/document.h>
#include <dcopobject.h>
#include <tdeparts/mainwindow.h>
#include <tdeparts/partmanager.h>
#include <tdeparts/part.h>

#include <tqsplitter.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqwidgetstack.h>
#include <tqstring.h>
#include <tqtoolbox.h>

#include "kileappIface.h"
#include "docpart.h"
#include "kilefileselect.h"
#include "kileinfo.h"
#include "symbolview.h"

#include "latexoutputinfo.h"
#include "latexoutputfilter.h"

#include "codecompletion.h"        // code completion (dani)
#include "kileedit.h"              // advanced editor (dani)
#include "kilehelp.h"              // kile help (dani)
#include "quickpreview.h"
#include "kileabbrevview.h"

#define ID_HINTTEXT 301
#define ID_LINE_COLUMN 302

#define KILERC_VERSION 6

class TQFileInfo;
class TQTimer;
class TQSignalMapper;
class TQIconViewItem;

class TDEToolBar;
class TDEAction;
class TDEActionMenu;
class TDERecentFilesAction;
class TDEToggleFullScreenAction;
class TDEToggleToolBarAction;
class KMultiTabBar;

class KileLyxServer;
class KileEventFilter;
class KileProject;
class KileProjectItem;
class KileProjectView;
class TemplateItem;
class KileAutoSaveJob;
class KileErrorHandler;
class KileSideBar;

namespace KileAction { class TagData; }
namespace KileDocument { class Info; class TextInfo; class Extensions; }
namespace KileTool { class Manager; class Factory; }
namespace KileWidget { class LogMsg; class Output; class Konsole; class Structure; }

//TODO remove once we stop supporting pre 1.7 user tools
struct userItem
{
	TQString name, tag;
};

/**
 * @author Jeroen Wijnhout
 **/

/**
 * The Kile main class. It acts as the mainwindow, information manager and DCOP interface.
 **/
class Kile : public KParts::MainWindow, public KileAppDCOPIface, public KileInfo
{
	TQ_OBJECT
  

public:
	Kile( bool allowRestore = true, TQWidget *parent = 0, const char *name = 0 );
	~Kile();

public slots:
	/**
	 * @param line : Jump to give line in current editor (can be called via DCOP interface).
	 **/
	void setLine( const TQString &line);
	void setCursor(const KURL &, int, int);
	void setActive();
	int run(const TQString &);
	int runWith(const TQString &, const TQString &);
	void runArchiveTool();
	void runArchiveTool(const KURL&);
	void openDocument(const TQString & url);
	void fileSelected(const TQString & url) { openDocument(url); } //backwards compatibility
	void closeDocument();
	void showTip();
	
/* actions */
private:
    void showEvent(TQShowEvent *e);
    void hideEvent(TQHideEvent *e);
    TQWidget *m_focusWidget;

	void setupStatusBar();
	void setupSideBar();
	void setupProjectView();
	void setupStructureView();
	void setupScriptsManagementView();
	void setupSymbolViews();
	void enableSymbolViewMFUS();
	void disableSymbolViewMFUS();
	void setupAbbreviationView();
	void setupBottomBar();
	void setupGraphicTools();
	void setupPreviewTools();
	void setupActions();
	void setupTools();
	void setupUserTagActions();
	void cleanUpActionList(TQPtrList<TDEAction> &, const TQStringList & tools);

	bool kateCompletionPlugin();
	void checkKateSettings();
	
	void initMenu();
	void setMenuItems(TQStringList &list, TQMap<TQString,bool> &dict);
	void updateMenu();
	void updateActionList(TQPtrList<TDEAction> *list, bool state);
	TQMap<TQString,bool> m_dictMenuAction, m_dictMenuFile, m_dictMenuProject;
	
	TDEToolBar						*m_toolsToolBar;
	TDEActionMenu 					*m_menuUserTags;
	TQValueList<KileAction::TagData>	m_listUserTags;
	TQValueList<userItem>			m_listUserTools;
	TQPtrList<TDEAction> 				m_listUserTagsActions, m_listQuickActions, m_listCompilerActions, m_listConverterActions, m_listViewerActions, m_listOtherActions;
	TDEAction							*m_actionEditTag;
	TDEActionSeparator			*m_actionEditSeparator;
	TDEAction 						*m_paStop, *m_paPrint;
	TDEToggleAction 					*ModeAction, *WatchFileAction;
	TDEToggleAction 					*m_actionMessageView;
	TDERecentFilesAction				*m_actRecentFiles;
	TDEToggleFullScreenAction			*m_pFullScreen;

/* GUI */
private:
	//widgets
	KileSideBar			*m_sideBar;
	KileAbbrevView		*m_kileAbbrevView;
	TQWidgetStack 			*m_topWidgetStack;
	TQSplitter 			*m_horizontalSplitter, *m_verticalSplitter;
	TQToolBox			*m_toolBox;
	SymbolView			*m_symbolViewMFUS, *m_symbolViewRelation, *m_symbolViewArrows, *m_symbolViewMiscMath, *m_symbolViewMiscText, *m_symbolViewOperators, *m_symbolViewUser, *m_symbolViewDelimiters, *m_symbolViewGreek, *m_symbolViewSpecial, *m_symbolViewCyrillic;

	//parts
	KParts::PartManager 		*m_partManager;
	TQString 			m_wantState, m_currentState;
	
private slots:
	void toggleMode();
	void toggleWatchFile();
	void showEditorWidget();
	void refreshStructure();

	void helpLaTex();

private slots:
	bool resetPart();
	void activePartGUI(KParts::Part *);
	void showToolBars(const TQString &);
	void enableKileGUI(bool);
	void slotToggleFullScreen();

public slots:
	void prepareForPart(const TQString &);

/* config */
private:
	TDEConfig			*m_config;
	int 			m_horSplitRight, m_horSplitLeft, m_verSplitTop, m_verSplitBottom;
	TQStringList 		m_recentFilesList, m_listDocsOpenOnStart, m_listProjectsOpenOnStart;

	void setViewerToolBars();
signals:
	/**
	 * Emit this signal when the configuration is changed. Classes that read and write to the global TDEConfig object
	 * should connect to this signal so they can update their settings.
	 **/
	void configChanged();

private slots:
	void restoreFilesAndProjects(bool allowRestore);
	void readGUISettings();
	void readUserSettings();
	void readRecentFileSettings();
	void saveSettings();

	void readConfig();

	void generalOptions();
	void configureKeys();
	void configureToolbars();
	void slotPerformCheck();

private slots:
	/**
	 * Activates (sets up the GUI for the editor part) the view.
	 * @param updateStruct  If true, force an update of the structure view.
	 **/
	void activateView(TQWidget* view , bool updateStruct = true);

	void focusLog();
	void focusOutput();
	void focusKonsole();
	void focusEditor();
	void focusPreview();

    void sideOrBottomBarChanged(bool visible);

public slots:
	bool queryExit();
	bool queryClose();

	void changeInputEncoding();

	void newStatus(const TQString& = TQString());
	void updateModeStatus();
	void newCaption();
	void citeViewBib();

public slots:
	void openProject(const TQString& proj);

private:
	TDERecentFilesAction *m_actRecentProjects;

	//
	// documentinfo
	//
private slots:
	void showDocInfo(Kate::Document *doc = 0);
	void convertToASCII(Kate::Document *doc = 0);
	void convertToEnc(Kate::Document *doc = 0);

public:
	int lineNumber();

/* autosave */
private slots:
	void autoSaveAll();
	void enableAutosave(bool);

private:
	TQTimer *m_AutosaveTimer;

private slots:
	void runTool();

	void cleanAll(KileDocument::TextInfo *docinfo = 0);
	void cleanBib();

	void findInFiles();
	void findInProjects();
	void grepItemSelected(const TQString &abs_filename, int line);

/* insert tags */
private slots:
	/**
	 * @param td Inserts the TagData td into the current editor.
	 *
	 * It can wrap a tag around selected text.
	 **/
	void insertTag(const KileAction::TagData& td);
	/**
	* @param td Inserts the TagData td into the current editor
	* @param pkgs list of packages needed for this command
	*
	* warns if latex packages in pkgs are not included in the document 
	**/
	void insertTag(const KileAction::TagData& td, const TQStringList& pkgs);
	/**
	 * An overloaded member function, behaves essentially as above.
	 **/
	void insertTag(const TQString& tagB, const TQString& tagE, int dx, int dy);
	void insertAmsTag(const KileAction::TagData& td);
	void insertText(const TQString &text, const TQStringList &pkgs);
	void insertText(const TQString &text);

	void quickTabular();
	void quickArray();
	void quickTabbing();
	void quickDocument();
	void quickFloat();
	void quickMathenv();
	void quickPostscript();
	void quickTabulardialog(bool tabularenv);

	void editUserMenu();

	void includeGraphics();

private:
	KileLyxServer		*m_lyxserver;
			
private:
	KileErrorHandler 	*m_errorHandler;
 	
// QuickPreview
private slots:
	void slotQuickPreview(int type);

	void quickPreviewEnvironment() { slotQuickPreview(KileTool::qpEnvironment); }
	void quickPreviewSelection()   { slotQuickPreview(KileTool::qpSelection);   }
	void quickPreviewSubdocument() { slotQuickPreview(KileTool::qpSubdocument); }
	void quickPreviewMathgroup()   { slotQuickPreview(KileTool::qpMathgroup);   }
};

#endif
