//////////////////////////////////////////////////////////////////////////////
//
//    FUZZYCOMPARE.CPP
//
//    Copyright (C) 2001 Richard Groult <rgroult at jalix.org> (from ShowImg project)
//    Copyright (C) 2004 Gilles Caulier <caulier dot gilles at gmail dot com>
//    Copyright (C) 2004 Richard Groult <rgroult at jalix.org>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef FUZZYCOMPARE_H
#define FUZZYCOMPARE_H

class TQImage;
class TQObject;
class TQStringList;
#include <tqdict.h>
#include <tqptrvector.h>
#include <tqfile.h>
#include "compareoperation.h"

namespace KIPIFindDupplicateImagesPlugin
{
class FindDuplicateImages;
class ImageSimilarityData;

class FuzzyCompare :public CompareOperation
{
public:
    FuzzyCompare( TQObject* parent, const TQString& cacheDir );
    void setApproximateThreeshold( float approximateLevel ) { m_approximateLevel = approximateLevel; }
    TQDict < TQPtrVector < TQFile > > compare(const TQStringList& filesList );

protected:
    ImageSimilarityData* image_sim_fill_data(TQString filename);
    float image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, float min);
    char getRed(TQImage *im, int x, int y);
    char getGreen(TQImage *im, int x, int y);
    char getBlue(TQImage *im, int x, int y);

private:
    TQObject* m_parent;
    const TQString m_cacheDir;
    float m_approximateLevel;
};

}

#endif /* FUZZYCOMPARE_H */

