/***************************************************************************
 *   Copyright (C) 2007 by Markus Leuthold   *
 *   <kusi (+at) forum.titlis.org>   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.        *
 ***************************************************************************/

#ifndef _VIEWERWIDGET_H_
#define _VIEWERWIDGET_H_

//QT includes
#include <tqgl.h>
#include <tqdir.h>
#include <tqimage.h>
#include <tqdatetime.h>
#include <iostream>
#include <kurl.h>
#include <kmimetype.h>
#include <tqregexp.h>
#include <tqcursor.h>
#include <tqtimer.h>

//kipi includes
#include <libkipi/imageinfo.h>
#include <libkipi/interface.h>
#include <libkipi/imagecollection.h>

//local includes
#include "texture.h"

/**
 * @short OpenGL widget for image viewer 
 * @author Markus Leuthold <kusi (+at) forum.titlis.org>
 * @version 0.2
 */
 

//keep in mind that one cache entry takes 20MB for a 5mpix pic
#define CACHESIZE 4
#define EMPTY 99999

namespace KIPIviewer {
using namespace std;

enum OGLstate {
        oglOK, oglNoRectangularTexture, oglNoContext
};	

class ViewerWidget : public TQGLWidget
{
    TQ_OBJECT
  
			
public:
	ViewerWidget(KIPI::Interface*);
	~ViewerWidget() {
		glDeleteTextures(1,tex);
		for(int i=0;i<CACHESIZE;i++) {
			cache[i].file_index=EMPTY;
			delete cache[i].texture;
		}
	}
	
    virtual void initializeGL();
    virtual void resizeGL(int w, int h);
    virtual void paintGL();
    void drawImage(Texture * tex);
    void downloadTex(Texture * tex);
    Texture * loadImage(int file_index);
    void prevImage();
    void nextImage();
    void zoom(int mdelta, TQPoint pos, float factor);
    virtual void mouseReleaseEvent(TQMouseEvent * e);
    virtual void keyReleaseEvent ( TQKeyEvent * e );
    OGLstate getOGLstate();

protected:
	struct Cache {
		int file_index;
		Texture * texture;
		
	};
	
	enum WheelAction {
		zoomImage, changeImage
	};
	Texture * texture;
	unsigned int old_file_idx,file_idx,idx, oldidx;
	float ratio_view_y,ratio_view_x,delta;
    TQTime timer;
    TQDir directory;
    TQStringList files;
    unsigned char *  imageJPEGLIB;
	Cache cache[CACHESIZE];
	GLuint tex[3];
    float vertex_height,vertex_width,vertex_left,vertex_top,vertex_right,vertex_bottom;
    TQPoint startdrag, previous_pos;
	WheelAction wheelAction;
    bool firstImage;
    TQSize zoomsize;
    TQTimer timerMouseMove;
    TQCursor moveCursor, zoomCursor;
	float zoomfactor_scrollwheel,  zoomfactor_mousemove,  zoomfactor_keyboard;
	TQString nullImage;
	KIPI::Interface * kipiInterface;

protected:
    virtual void keyPressEvent(TQKeyEvent *k);
    virtual void wheelEvent ( TQWheelEvent * e );
    virtual void mouseMoveEvent ( TQMouseEvent * e );
    virtual void mousePressEvent ( TQMouseEvent * e );
    virtual void mouseDoubleClickEvent(TQMouseEvent * e );
private slots:
    void timeoutMouseMove();
};
}; //namespace KIPIviewer
#endif // _VIEWERWIDGET_H_
