/***************************************************************************
                          tphoto.h  -  description
                             -------------------
    begin                : Thu Sep 12 2002
    copyright            : (C) 2002 by Todd Shoemaker
                         : (C) 2007 Angelo Naselli
    email                : jtshoe11@yahoo.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TPHOTO_H
#define TPHOTO_H

// TQt includes.

#include <tqstring.h>
#include <tqptrlist.h>
#include <tqrect.h>
#include <tqiconview.h>

// KDE includes.

#include <kurl.h>
#include <libkexiv2/kexiv2.h>

class TQImage;
class TQPixmap;

class KPrinter;

namespace KIPIPrintWizardPlugin
{

class TPhoto 
{
  public:
    TPhoto(int thumbnailSize);
    ~TPhoto();

    KURL filename; // full path

    TQPixmap & thumbnail();
    TQImage    loadPhoto();

    int m_thumbnailSize;

    int width();
    int height();

    TQRect cropRegion;
    int copies;
    int rotation;
    KExiv2Iface::KExiv2 *exiv2Iface();

  private:
    TQPixmap *m_thumbnail;
    void loadCache();
    TQSize & size();
    TQSize * m_size;
    KExiv2Iface::KExiv2 *m_exiv2Iface;
};

}  // NameSpace KIPIPrintWizardPlugin

#endif // TPHOTO_H

