/***************************************************************************
                          boldmenuitem.cpp  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boldmenuitem.h"
#include <tqfont.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqstyle.h>
#include <kdebug.h>
#include <tdeglobalsettings.h>
#include <tdeversion.h>
#include <tdeapplication.h>


BoldMenuItem::BoldMenuItem(const TQString &text, const TQColor &active_text_color,
  bool bold)
  : m_text(text), m_active_text_color(active_text_color), m_bold(bold)
{
}

BoldMenuItem::~BoldMenuItem(){
}

void BoldMenuItem::paint(TQPainter* painter, const TQColorGroup& /*cg*/,
	  bool act, bool /*enabled*/, int x, int y, int w, int h)
{
  TQFont font = painter->font();
  if (font.bold() != m_bold) {
    font.setBold(m_bold);
    painter->setFont(font);
  }
  //if (act) painter->setPen(TDEGlobalSettings::highlightedTextColor());
  //if (act) painter->setPen(cg.highlightedText());
  if (act) painter->setPen(m_active_text_color);
  kdDebug() << "bg color = " << painter->brush().color().rgb() << endl;

  painter->drawText(x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip,
    m_text);
  //TDEApplication::style().drawItem(painter, TQRect(x, y, w, h), AlignLeft | AlignVCenter | ShowPrefix | DontClip,
  //  cg, enabled, 0, m_text);
}	


void BoldMenuItem::setFont(const TQFont& font)
{
  m_size = TQFontMetrics(font).size(AlignLeft | AlignVCenter | ShowPrefix | DontClip,
    m_text);
  TQCustomMenuItem::setFont(font);
}

