/**
 * Copyright (C) 2003 by Koos Vriezen <koos.vriezen@gmail.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef _KXINEPLAYER_H_
#define _KXINEPLAYER_H_

#include <tqapplication.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqsessionmanager.h>

struct XineMovieParamEvent : public TQEvent {
    XineMovieParamEvent (int l, int w, int h, const TQStringList & al, const TQStringList & sl, bool ff=false);
    int length;
    int width;
    int height;
    TQStringList alang;
    TQStringList slang;
    bool first_frame;
};

struct XineURLEvent : public TQEvent {
    XineURLEvent (const TQString & u);
    TQString url;
};

struct XineTitleEvent : public TQEvent {
    XineTitleEvent (const char *);
    TQString title;
};

struct XineProgressEvent : public TQEvent {
    XineProgressEvent (int p);
    int progress;
};

class KXinePlayer : public TQApplication {
    TQ_OBJECT
  
public:
    KXinePlayer (int argc, char ** argv);
    ~KXinePlayer ();

    void init ();
    void finished ();
    void saturation (int val);
    void hue (int val);
    void contrast (int val);
    void brightness (int val);
    void volume (int val);
    void seek (int val);
    bool event (TQEvent * e);
    void setAudioLang (int, const TQString &);
    void setSubtitle (int, const TQString &);
public slots:
    void play (int repeat_count);
    void stop ();
    void pause ();
    void updatePosition ();
    void postFinished ();
protected:
    void saveState (TQSessionManager & sm);
};

#endif //_KXINEPLAYER_H_
