/***************************************************************************
   begin                : Thu Apr 17 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tdeapplication.h"
#include "kmfnewdocdlg.h"
#include "../version.h"
#include "kmfnewdocdlg.moc"

// TQt includes
#include "tqpixmap.h"
#include "tqpainter.h"
#include "tqlabel.h"
#include "tqstring.h"
#include "tqpushbutton.h"
#include "tqrect.h"


// KDE includes
#include "kstandarddirs.h"
#include "kdebug.h"
namespace KMF {
KMFNewDocDlg::KMFNewDocDlg( TQWidget *parent, const char *name, WFlags fl ) : KMyFirewallNewDocument( parent, name, fl ) {
	TDEStandardDirs std_dir;
	TQString dir = std_dir.findResource( "data", "kmyfirewall/pics/splash_cut.png" );
	kdDebug() << "Found Splashscreen at: " << dir << endl;

	TQPixmap pic = TQPixmap::fromMimeSource( dir );
	TQFont f( "helvetica", 8, TQFont::Bold );
	if ( pic.isNull() )
		return ;
	TQPainter p( &pic );
	p.setFont( f );
	p.setPen( TQt::white );
	p.drawText( 165, 45, TQString( "Version %1" ).arg( KMYFIREWALL_VERSION ) );
	p.drawText( 93, 215, TQString( "%1" ).arg( COPYRIGHT_DATE ) );
	p.drawText( 70, 230, TQString( "%1" ).arg( COPYRIGHT_OWNER ) );
	if ( pic.isNull() )
		return ;
	l_pic->setPixmap( pic );
	connect( b_cancel, TQ_SIGNAL( clicked() ), this, TQ_SLOT( reject() ) );
	connect( b_close, TQ_SIGNAL( clicked() ), this, TQ_SLOT( reject() ) );
	connect( b_empty, TQ_SIGNAL( clicked() ), this, TQ_SLOT( loadEmpty() ) );
	connect( b_template, TQ_SIGNAL( clicked() ), this, TQ_SLOT( loadTemplate() ) );
	connect( b_load_saved, TQ_SIGNAL( clicked() ), this, TQ_SLOT( loadSaved() ) );
	connect( b_help, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotHelp() ) );
	TQRect screen = TQApplication::desktop() ->screenGeometry();
	TQRect mainRect;
	screen = TQApplication::desktop() ->screenGeometry( TQApplication::desktop() ->screenNumber( mainRect.center() ) );
	move( screen.center() - TQPoint( width() / 2, height() / 2 ) );
}

KMFNewDocDlg::~KMFNewDocDlg() {}



void KMFNewDocDlg::reject() {
	close();
}

void KMFNewDocDlg::loadEmpty() {
	hide();
	emit sigNewDocLoadEmpty();
	close();
}
void KMFNewDocDlg::loadWizard() {
	hide();
	emit sigNewDocLoadWizard();
	close();
}
void KMFNewDocDlg::loadTemplate() {
	hide();
	emit sigNewDocLoadTemplate();
	close();
}
void KMFNewDocDlg::loadSaved() {
	hide();
	emit sigNewDocLoadSaved();
	close();
}
void KMFNewDocDlg::slotHelp() {
	kapp->invokeHelp();
}

}
