###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


##### look for libofx

if( WITH_LIBOFX )
  pkg_search_module( LIBOFX libofx )
  if( NOT LIBOFX_FOUND )
      tde_message_fatal( "libofx is requested, but was not found on your system" )
  else()
      set( HAVE_LIBOFX 1 )
  endif()
endif()


##### look for functions
check_function_exists( atoll HAVE_ATOLL )
check_function_exists( strtoll HAVE_STRTOLL )
check_library_exists( m round "" HAVE_ROUND )


##### check for CppUnit

find_library(CPPUNIT_LIBRARY NAMES cppunit)
if( CPPUNIT_LIBRARY )
  set( HAVE_LIBCPPUNIT 1 )
endif()


##### check for tqt plugins dir

if( BUILD_DESIGNER_PLUGIN )
  execute_process(
    COMMAND ${PKG_CONFIG_EXECUTABLE}
      tqt-mt --variable=pluginsdir
    OUTPUT_VARIABLE TQT_PLUGINS_DIR
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
endif()


##### check for programs needed for developer documentation

if( BUILD_DEVELOPER_DOCS )
  find_program( ICONV_EXECUTABLE   NAMES iconv )
  if( NOT ICONV_EXECUTABLE )
    tde_message_fatal( "iconv is required to generate developer documentation but not found on your system")
  endif()

  find_program( SED_EXECUTABLE     NAMES gsed sed )
  if( NOT SED_EXECUTABLE )
    tde_message_fatal( "sed is required to generate developer documentation but not found on your system")
  endif()

  if( BUILD_PDF_DOCS )
    find_program( HTML2PS_EXECUTABLE NAMES html2ps )
    if( NOT HTML2PS_EXECUTABLE )
      tde_message_fatal( "html2ps is required to generate pdf for developer documentation but not found on your system")
    endif()

    find_program( PS2PDF_EXECUTABLE  NAMES ps2pdf )
    if( NOT PS2PDF_EXECUTABLE )
      tde_message_fatal( "ps2pdf is required to generate pdf for developer documentation but not found on your system")
    endif()
  endif()
endif()
