/***************************************************************************
                          kbackupdialog.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Michael Edwardes
    email                : mte@users.sourceforge.net
                             Javier Campos Morales <javi_c@ctv.es>
                             Felix Rodriguez <frodriguez@mail.wesleyan.edu>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqpixmap.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kstandarddirs.h>

#include <tdeconfig.h>
#include <kdirselectdialog.h>
#include <tdeglobalsettings.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kguiitem.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kbackupdlg.h"

KBackupDlg::KBackupDlg( TQWidget* parent,  const char* name/*, bool modal*/)
  : kbackupdlgdecl( parent,  name , true)
{
  readConfig();

  // add icons to buttons
  TDEIconLoader *il = TDEGlobal::iconLoader();
  btnOK->setGuiItem(KStdGuiItem::ok());
  btnCancel->setGuiItem(KStdGuiItem::cancel());

  KGuiItem chooseButtenItem( i18n("C&hoose..."),
                    TQIconSet(il->loadIcon("folder", TDEIcon::Small, TDEIcon::SizeSmall)),
                    i18n("Select mount point"),
                    i18n("Use this to browse to the mount point."));
  chooseButton->setGuiItem(chooseButtenItem);
  
  connect(chooseButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(chooseButtonClicked()));
  connect(btnOK,TQ_SIGNAL(clicked()),this,TQ_SLOT(accept()));
  connect(btnCancel,TQ_SIGNAL(clicked()),this,TQ_SLOT(reject()));
}

KBackupDlg::~KBackupDlg()
{
  writeConfig();
}

void KBackupDlg::chooseButtonClicked()
{
  KURL newDir = KDirSelectDialog::selectDirectory(TDEGlobalSettings::documentPath());
  if (newDir.hasPath())
    txtMountPoint->setText(newDir.path());
}

void KBackupDlg::readConfig(void)
{
  TDEConfig *config = TDEGlobal::config();
  config->setGroup("Last Use Settings");
  mountCheckBox->setChecked(config->readBoolEntry("KBackupDlg_mountDevice", false));
  txtMountPoint->setText(config->readEntry("KBackupDlg_BackupMountPoint", "/mnt/floppy"));
}

void KBackupDlg::writeConfig(void)
{
  TDEConfig *config = TDEGlobal::config();
  config->setGroup("Last Use Settings");
  config->writeEntry("KBackupDlg_mountDevice", mountCheckBox->isChecked());
  config->writeEntry("KBackupDlg_BackupMountPoint", txtMountPoint->text());
  config->sync();
}

#include "kbackupdlg.moc"
