/***************************************************************************
                         kofxdirectconnectdlg.h
                             -------------------
    begin                : Sat Nov 13 2004
    copyright            : (C) 2002 by Ace Jones
    email                : acejones@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOFXDIRECTCONNECTDLG_H
#define KOFXDIRECTCONNECTDLG_H

// ----------------------------------------------------------------------------
// TQt Includes

// ----------------------------------------------------------------------------
// TDE Includes

class KTempFile;
class KOfxDirectConnectDlgPrivate;

namespace TDEIO
{
class Job;
class TransferJob;
}

// ----------------------------------------------------------------------------
// Project Includes

#include "mymoneyofxconnector.h"
#include "kofxdirectconnectdlgdecl.h"

/**
@author ace jones
*/
class KOfxDirectConnectDlg : public KOfxDirectConnectDlgDecl
{
TQ_OBJECT
  
public:
  KOfxDirectConnectDlg(const MyMoneyAccount&, TQWidget *parent = 0, const char *name = 0);
  ~KOfxDirectConnectDlg();

  void init(void);

signals:
  /**
    * This signal is emitted when the statement is downloaded
    * and stored in file @a fname.
    */
  void statementReady(const TQString& fname);

protected slots:
  void slotOfxFinished(TDEIO::Job*);
  void slotOfxData(TDEIO::Job*,const TQByteArray&);
  void slotOfxConnected(TDEIO::Job*);
  virtual void reject(void);

protected:
  void setStatus(const TQString& _status);
  void setDetails(const TQString& _details);

  KTempFile* m_tmpfile;
  MyMoneyOfxConnector m_connector;
  TDEIO::TransferJob* m_job;

private:
  /// \internal d-pointer class.
  class Private;
  /// \internal d-pointer instance.
  Private* const d;
};

#endif // KOFXDIRECTCONNECTDLG_H
