/***************************************************************************
                         mymoneyofxconnector.cpp
                             -------------------
    begin                : Sat Nov 13 2004
    copyright            : (C) 2002 by Ace Jones
    email                : acejones@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYOFXCONNECTOR_H
#define MYMONEYOFXCONNECTOR_H


// ----------------------------------------------------------------------------
// Library Includes

#include <libofx/libofx.h>

// if OFX has a major version number defined, we'll take it
// if not, we assume 0.8.3. 0.8.3 was the last version w/o version number info
#ifdef LIBOFX_MAJOR_VERSION
  #define LIBOFX_VERSION TDE_MAKE_VERSION(LIBOFX_MAJOR_VERSION, LIBOFX_MINOR_VERSION, LIBOFX_MICRO_VERSION)
#else
  #define LIBOFX_VERSION TDE_MAKE_VERSION(0,8,3)
#endif
#define LIBOFX_IS_VERSION(a,b,c) (LIBOFX_VERSION >= TDE_MAKE_VERSION(a,b,c))

// ----------------------------------------------------------------------------
// TQt Includes

class TQDate;

// ----------------------------------------------------------------------------
// TDE Includes
class KComboBox;

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneykeyvaluecontainer.h>

class MyMoneyAccount;
class MyMoneyInstitution;
class MyMoneyTransaction;

/**
 * @author Thomas Baumgart
 */
class OfxAppVersion
{
public:
  OfxAppVersion(KComboBox* combo, const TQString& appId);
  /**
   * This method returns the currently selected application id
   * as a colon separated value consisting of the application
   * and version (eg. "QWIN:1700").  If current value is the
   * default, an empty string is returned.
   */
  const TQString& appId(void) const;

private:
  TQMap<TQString, TQString> m_appMap;
  KComboBox*             m_combo;
};

/**
 * @author Thomas Baumgart
 */
class OfxHeaderVersion
{
public:
  OfxHeaderVersion(KComboBox* combo, const TQString& headerVersion);
  TQString headerVersion(void) const;

private:
  KComboBox*             m_combo;
};

/**
@author ace jones
*/
class MyMoneyOfxConnector
{
public:
  MyMoneyOfxConnector(const MyMoneyAccount& _account);
  TQString url(void) const;

  /**
   * Constructs the request for a statement. The first date
   * for which transactions will be requested is determined
   * by statementStartDate()
   */
  const TQByteArray statementRequest(void) const;
  const TQByteArray statementResponse(const TQDate& _dtstart) const;

private:
  void initRequest(OfxFiLogin* fi) const;
  TQDate statementStartDate(void) const;
  TQString iban(void) const;
  TQString fiorg(void) const;
  TQString fiid(void) const;
  TQString username(void) const;
  TQString password(void) const;
  TQString accountnum(void) const;
#if LIBOFX_IS_VERSION(0,9,0)
  OfxAccountData::AccountType accounttype(void) const;
#else
  AccountType accounttype(void) const;
#endif

private:
  const MyMoneyAccount& m_account;
  MyMoneyKeyValueContainer m_fiSettings;
};

#endif // OFXCONNECTOR_H
