/***************************************************************************
                          kmymoneycurrencyselector.cpp  -  description
                             -------------------
    begin                : Tue Apr 6 2004
    copyright            : (C) 2000-2004 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqpixmap.h>
#include <tqbitmap.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <kstandarddirs.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneycurrencyselector.h"

KMyMoneySecuritySelector::KMyMoneySecuritySelector(TQWidget *parent, const char *name ) :
  KComboBox(parent, name),
  m_displayItem(FullName),
  m_displayOnly(false),
  m_displayType(TypeAll)
{
  // update(TQString());
}

KMyMoneySecuritySelector::KMyMoneySecuritySelector(displayTypeE type, TQWidget *parent, const char *name ) :
  KComboBox(parent,name),
  m_displayItem(FullName),
  m_displayOnly(false),
  m_displayType(type)
{
  // update(TQString());
}

KMyMoneySecuritySelector::~KMyMoneySecuritySelector()
{
}

void KMyMoneySecuritySelector::selectDisplayItem(KMyMoneySecuritySelector::displayItemE item)
{
  m_displayItem = item;
  update(TQString());
}

void KMyMoneySecuritySelector::update(const TQString& id)
{
  MyMoneySecurity curr = MyMoneyFile::instance()->baseCurrency();
  TQString baseCurrency = curr.id();

  if(!id.isEmpty())
    curr = m_currency;

  this->clear();
  m_list.clear();
  if(m_displayType & TypeCurrencies)
    m_list += MyMoneyFile::instance()->currencyList();
  if(m_displayType & TypeSecurities)
    m_list += MyMoneyFile::instance()->securityList();

  // sort
  qHeapSort(m_list);

  TQValueList<MyMoneySecurity>::ConstIterator it;

  // construct a transparent 16x16 pixmap
  TQPixmap empty(16, 16);
  empty.setMask(TQBitmap(16, 16, true));

  int itemId = 0;
  int m_selectedItemId = 0;
  for(it = m_list.begin(); it != m_list.end(); ++it) {
    TQString display;
    switch(m_displayItem) {
      default:
      case FullName:
        if((*it).isCurrency()) {
          display = TQString("%2 (%1)").arg((*it).id()).arg((*it).name());
        } else
          display = TQString("%2 (%1)").arg((*it).tradingSymbol()).arg((*it).name());
        break;
        break;

      case Symbol:
        if((*it).isCurrency())
          display = (*it).id();
        else
          display = (*it).tradingSymbol();
        break;
    }
    if((*it).id() == baseCurrency) {
      insertItem(TQPixmap( locate("icon","hicolor/16x16/apps/kmymoney2.png")),
                          display, itemId);
    } else {
      insertItem(empty, display, itemId);
    }

    if(curr.id() == (*it).id()) {
      m_selectedItemId = itemId;
      m_currency = (*it);
    }

    itemId++;
  }
  setCurrentItem(m_selectedItemId);
}

void KMyMoneySecuritySelector::setDisplayOnly(const bool disp)
{
  if(disp == m_displayOnly)
    return;

  switch(disp) {
    case true:
      connect(this, TQ_SIGNAL(activated(int)), this, TQ_SLOT(slotSetInitialCurrency()));
      break;
    case false:
      disconnect(this, TQ_SIGNAL(activated(int)), this, TQ_SLOT(slotSetInitialCurrency()));
      break;
  }
  m_displayOnly = disp;
}

void KMyMoneySecuritySelector::slotSetInitialSecurity(void)
{
  setCurrentItem(m_selectedItemId);
}

const MyMoneySecurity& KMyMoneySecuritySelector::security(void) const
{
  return m_list[currentItem()];
}

void KMyMoneySecuritySelector::setSecurity(const MyMoneySecurity& currency)
{
  m_currency = currency;
  update(TQString("x"));
}

KMyMoneyCurrencySelector::KMyMoneyCurrencySelector(TQWidget *parent, const char *name ) :
  KMyMoneySecuritySelector(TypeCurrencies, parent, name)
{
}

#include "kmymoneycurrencyselector.moc"
