/***************************************************************************
                          knutvardata.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel@prynych.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTVARDATA_H
#define KNUTVARDATA_H


/*******************************/
/*    GLOBAL DEFINE            */
/*******************************/

#define DEFAULT_BG_COLOR TQt::lightGray
#define DEFAULT_FINGER_COLOR TQt::black
#define DEFAULT_OK_COLOR TQt::green
#define DEFAULT_WARNNING_COLOR TQt::yellow
#define DEFAULT_ERROR_COLOR TQt::red
#define DEFAULT_SCALE_COLOR TQt::black
#define DEFAULT_FONT_COLOR TQt::black
#define DEFAULT_KICON_COLOR TQt::white

#include <tdelocale.h>

#include "knutnet.h"
#include "knutupsdata.h"
#include "knutconst.h"

#include <tqcolor.h>
#include <tqfont.h>
#include <tqstring.h>


//  const char *nameUpsVars1[] = {
//    "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID","BATTVOLT","OUTVOLT","CURRENT","BATT_TEMP","BATT_CURRENT"};

//  const char *nameUpsVars2[] = {
//    "none", "input.voltage", "battery.charge", "ups.temperature", "input.frequency", "ups.load", "ambient.temperature", "ambient.humidity","battery.voltage","output.voltage","output.current","battery.temperature","battery.current"};


/**
  *@author Daniel Prynych
  */


 /**
  * Class contain data about analog panels,
  * name, ..
  * Describes view of panel.
  * Trida obsahuje data o analogovych panelech,
  * nazev, atd.
  * Popisuje jak ma prislusny panel vypadat
  *
  * @author Daniel Prynych
  * @short Information about analog panels
  * @version 0.4
  **/

class TQString;
class TQColor;
class TQFont;

class KNutVarData {

public:

  enum mainWindowStartVariant{
      mw_yes=0,
      mw_no,
      mw_auto
      };

struct ScaleStructDef {
  int start;
  int end;
  int scaleColor;
  };

struct SettingDataDef {
  int countCols;
  int x;
  int y;
  int width;
  int height;
  TQColor mainBackgroundColor;
  TQColor mPanelBackgroundColor;
  TQColor aPanelBackgroundColor;
  TQColor analogFingerColor;
  TQColor analogOKColor;
  TQColor analogWarnningColor;
  TQColor analogErrorColor;
  TQColor analogScaleColor;
  TQColor analogFontColor;
  unsigned int panelFlags;
  int inputVoltage;
  int inputFrequency;
  bool lowHighXfer;
  bool areYouSure;
  mainWindowStartVariant useMainWindow;
  int useMessageWindow;
  bool customBColor;
  bool customBPanelColor;
  bool customBAnalogColor;
  bool customOAnalogColor;
  TQFont mPanelFont; // main panel font
  TQFont aPanelFont; // analog panel font
  TQFont systemFont; // system font
  bool customFont; // use custom font
  bool useDescription;
  unsigned int toolTipFlags;
  bool customTDEIconColor;
  TQColor kIconBackgroundColor;
  int typeOfTDEIcon;
  int typeDigitalProcessing;
  bool activatedMainWindow;
  };

struct upsInfoDef{  //include generally informations about active (selected) UPS
  KNutNet *upsNet;  // pointer to instance of KNutNet
  KNutUpsData::upsRecordDef record; // include information about information of ups (name, address, login, password ...)
  int netError; // kod chyby pri spojeni // kode if error of conection
  bool errorUpsData;
  // state of connection to usbd, this isn't state of knutnet
  knc::upsDriverConnection upsDriverState; // defined in knutconst.h
  int oldState; // code of lost state of UPS  kod posledniho stavu UPS
  TQString name;
  TQString password;
  int nutVariables;
  int nutProtocol;
  TQString runtimeVar;
  TQString lowxferVar;
  TQString highxferVar;
  TQString statusVar;
  TQString upsLoadVar;
  bool reconnecting;  // is true when program is in reconnecting stage
  int reconnectCount; 
  };

struct VarStrucDef {
  TQString nameAnalog; // jmeno promene v meraku  napr. UPS Load
  TQString nameUnit; // merna jednotka napr %
  int typeAnalog; //typ meraku
  int numberItem; //pocet casti stupnice neni v souvislosti barvou
  int numberInItem; //pocet casti stupnice uvnitr dilku stupnice
  int start; // pocatecni hodnota v meraku
  int end; // konecna hodnota v meraku
  struct ScaleStructDef scaleStruct[5];
  };


  KNutVarData();
  ~KNutVarData();

 /**
  * Gets data of analog measure panel, type of measure panel, 
  * Vrati data analogoveho mericiho panelu.
  * typ meraku, pocet dilku stupnice, merici jedntotku atd
  * data je mozno take nastavovat
  * @param seqNumber Kod typu meraky.
  * @return  Data pro zadany typ panelu.
  * @since  0.1
  **/
VarStrucDef getData (const int seqNumber) const;


 /**
  * Puts data of analog measure panel
  * Nastavi data analogoveho mericiho panelu.
  *
  * @param seqNumber Kod typu meraky.
  * @param data Data pro zadany typ panelu.
  *
  * @since  0.1
  **/
void putData (const int seqNumber, VarStrucDef& varStruc);

 /**
  * Sets data of analog measure panel for input and output voltage
  * Nastavi data analogoveho mericiho panelu pro vstupni a vystupni napeti.
  *
  * @param typeVoltage Typ vstupniho napeti 230/120.
  *
  * @since  0.1
  **/
void setVoltage (const int typeVoltage);

 /**
  * Sets data of analog measure panel for input frequence
  * Nastavi data analogoveho mericiho panelu pro vstupni frekvence.
  *
  * @param typeFrequence Typ vstupni frekvence 50/60.
  *
  * @since  0.1
  **/
void setFrequency (const int typeFrequence);

 /**
  * Nastavi vnitrni cast vybarveni podle low/high xfer,
  * low/high-XFER udava rozpeti pri kterem UPS zpracovava napeti ze site.
  *
  * @param lowXfer Pocatecni hodnota.
  * @param highXfer Konecna hodnota.
  * @since  0.1
  **/
void setXfer (const float lowXfer, const float highXfer);

 /**
  * Vrati dlouhy nazev analogoveho panelu,
  * je to jmeno merene veliciny
  *
  * @param seqNumber Kod typu merakuss.
  * @since  0.1
  **/
TQString getNameAnalogData (const int seqNumber);


/**
 * Prevede kod chyby na jeho textovou reprezentaci
 *
 * @since  0.2
 **/
  static const TQString errorToText (const int error);


/**
 * Zobrazi jmeno chyby na zaklade jeho cisla.
 *
 * @since  0.1.2
 **/
  static void showError (const int error);


private:

  enum {aRegWhite,aRegGreen,aRegYellow,aRegRed,aRegBlue,aRegCyan,aRegMagenta,aRegBlack};

  VarStrucDef m_dataVar[ knc::NumberOfTypes ];  /* udrzuje popis Anagovych meraku pro danou promenou jmeno zabarveni typ meraky */
  VarStrucDef m_dataVarVoltage[2];
  VarStrucDef m_dataVarFrequence[2];

  static const int U230V = 0;
  static const int U120V = 1;
  static const int F50HZ = 0;
  static const int F60HZ = 1;

  TQString m_upsVarNameAnalog[ knc::NumberOfTypes ];//array of strings - includes name of analog meters
};

#endif
