/*
 * colorrange.h -- Part of Chalk
 *
 * Copyright (c) 2004 Boudewijn Rempt (boud@valdyas.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include <math.h>

#include <stdlib.h>

#include <tqslider.h>
#include <tqpoint.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeinstance.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kdebug.h>
#include <kgenericfactory.h>

#include <kis_doc.h>
#include <kis_image.h>
#include <kis_layer.h>
#include <kis_paint_device.h>
#include <kis_global.h>
#include <kis_types.h>
#include <kis_view.h>
#include <kis_selection.h>
#include <kis_selection_manager.h>
#include "colorrange.h"
#include "dlg_colorrange.h"

typedef KGenericFactory<ColorRange> ColorRangeFactory;
K_EXPORT_COMPONENT_FACTORY( chalkcolorrange, ColorRangeFactory( "chalk" ) )

ColorRange::ColorRange(TQObject *parent, const char *name, const TQStringList &)
    : KParts::Plugin(parent, name)
{

    if (parent->inherits("KisView")) {
        setInstance(ColorRangeFactory::instance());
        setXMLFile(locate("data","chalkplugins/colorrange.rc"), true);
        m_view = dynamic_cast<KisView*>(parent);
        m_view->canvasSubject()->selectionManager()->addSelectionAction( new TDEAction(i18n("&Color Range..."), 0, 0, this, TQ_SLOT(slotActivated()), actionCollection(), "colorrange") );

    }
}

ColorRange::~ColorRange()
{
}

void ColorRange::slotActivated()
{
    KisPaintDeviceSP layer = m_view->canvasSubject()->currentImg()->activeDevice();
    if (!layer) return;

    DlgColorRange * dlgColorRange = new DlgColorRange(m_view, layer, m_view, "ColorRange");
    TQ_CHECK_PTR(dlgColorRange);

    dlgColorRange->exec();
}

#include "colorrange.moc"

