/* This file is part of the KDE project
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __VSTROKEFILLPREVIEW_H__
#define __VSTROKEFILLPREVIEW_H__

#include <tqframe.h>
#include <tqpixmap.h>

class VKoPainter;
class VFill;
class VStroke;
class KarbonPart;

class VStrokeFillPreview : public TQFrame
{
	TQ_OBJECT
  

public:
	VStrokeFillPreview( KarbonPart *part, TQWidget* parent = 0L, const char* name = 0L );
	~VStrokeFillPreview();

	virtual TQSize sizeHint() const
		{ return TQSize( 50, 50 ); }
	virtual TQSize minimumSizeHint() const
		{ return TQSize( 20, 20 ); }
	virtual TQSizePolicy sizePolicy() const
		{ return TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Expanding ); }

	void update( const VStroke &, const VFill & );

	virtual bool eventFilter( TQObject* object, TQEvent* event );

	bool strokeIsSelected() const { return m_strokeWidget; }
	void setFillSelected();
	void setStrokeSelected();
signals:
	void strokeChanged( const VStroke & );
	void fillChanged( const VFill& );
	void fillSelected();
	void strokeSelected();

protected:
	virtual void paintEvent( TQPaintEvent* event );

private:
	VKoPainter* m_painter;
	void drawFill( const VFill & );
	void drawStroke( const VStroke & );
	TQPixmap m_pixmap;
	KarbonPart *m_part;
	bool m_strokeWidget;
	VFill m_fill;
	VStroke m_stroke;
};

#endif

