/* This file is part of the KDE project
   Copyright (C) 2003, 2004 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
 
#include "kptpertview.h"

#include "kptview.h"
#include "kptpertcanvas.h"
#include "kptpart.h"
#include "kptproject.h"
#include "kptrelation.h"
#include "kptcontext.h"

#include <kdebug.h>

#include <tqsplitter.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqlistview.h>
#include <tqheader.h>
#include <tqpopupmenu.h>

#include <kprinter.h>

namespace KPlato
{

PertView::PertView( View *view, TQWidget *parent, TQLayout *layout )
    : TQWidget( parent, "Pert view" ),
    m_mainview( view ),
    m_node( 0 )
{
    init(layout);
}

PertView::~PertView()
{
}

void PertView::init(TQLayout */*layout*/)
{
    //kdDebug()<<k_funcinfo<<endl;
    TQGridLayout *gl = new TQGridLayout(this, 1, 1, -1, -1, "Pert TQGridLayout");
    m_canvasview = new PertCanvas(this);
        gl->addWidget(m_canvasview, 0, 0);
    draw();
    connect(m_canvasview, TQ_SIGNAL(rightButtonPressed(Node *, const TQPoint &)), this, TQ_SLOT(slotRMBPressed(Node *,const TQPoint &)));
    connect(m_canvasview, TQ_SIGNAL(updateView(bool)), m_mainview, TQ_SLOT(slotUpdate(bool)));

    connect(m_canvasview, TQ_SIGNAL(addRelation(Node*, Node*)), TQ_SLOT(slotAddRelation(Node*, Node*)));
    connect(m_canvasview, TQ_SIGNAL(modifyRelation(Relation*)), TQ_SLOT(slotModifyRelation(Relation*)));
}    

void PertView::draw() 
{
    //kdDebug()<<k_funcinfo<<endl;
    m_canvasview->draw(m_mainview->getPart()->getProject());
    m_canvasview->show();
}

void PertView::slotRMBPressed(Node *node, const TQPoint & point)
{
    //kdDebug()<<k_funcinfo<<" node: "<<node->name()<<endl;
    m_node = node;
    if (node && (node->type() == Node::Type_Task || node->type() == Node::Type_Milestone)) {
        TQPopupMenu *menu = m_mainview->popupMenu("task_popup");
        if (menu)
        {
            /*int id =*/ menu->exec(point);
            //kdDebug()<<k_funcinfo<<"id="<<id<<endl;
        }
        return;
    }
    if (node && node->type() == Node::Type_Summarytask) {
        TQPopupMenu *menu = m_mainview->popupMenu("node_popup");
        if (menu)
        {
            /*int id =*/ menu->exec(point);
            //kdDebug()<<k_funcinfo<<"id="<<id<<endl;
        }
        return;
    }
    //TODO: Other nodetypes
}

void PertView::slotAddRelation(Node* par, Node* child)
{
    kdDebug()<<k_funcinfo<<endl;
    emit addRelation(par, child);
}

void PertView::slotModifyRelation(Relation *rel)
{
    kdDebug()<<k_funcinfo<<endl;
    emit modifyRelation(rel);
}

void PertView::print(KPrinter &printer)
{
    Q_UNUSED(printer);
    kdDebug()<<k_funcinfo<<endl;

}

Node *PertView::currentNode()
{
    return m_canvasview->selectedNode(); 
}

bool PertView::setContext(Context::Pertview &context)
{
    Q_UNUSED(context);
    //kdDebug()<<k_funcinfo<<endl;
    return true;
}

void PertView::getContext(Context::Pertview &context) const
{
    Q_UNUSED(context);
    //kdDebug()<<k_funcinfo<<endl;
}

}  //KPlato namespace

#include "kptpertview.moc"
