/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef SIDEBAR_H
#define SIDEBAR_H

#include <tqrect.h>
#include <tqstringlist.h>
#include <tqtabwidget.h>
#include <tqvalidator.h>

#include <kiconview.h>
#include <tdelistview.h>

class TQListViewItem;
class KPrDocument;
class KPrView;
class TQDropEvent;
class TQPopupMenu;
class KPrOutline;
class OutlineSlideItem;
class KPrThumbBar;
class ThumbToolTip;
class KPrPage;


class KPrRenamePageValidator : public TQValidator
{
  public:
    KPrRenamePageValidator( const TQStringList & list=TQStringList() )
        : TQValidator( 0, 0 ), mStringList( list ) {}
    virtual State validate( TQString & input, int & pos ) const;

  protected:
    TQStringList mStringList;
};

class KPrSideBarBase
{
public:
    KPrSideBarBase(KPrDocument *_doc, KPrView *_view);
    void setViewMasterPage( bool _b );
protected:
    KPrDocument *m_doc;
    KPrView *m_view;
    bool m_viewMasterPage;
};

class KPrThumbBar : public TDEIconView, public KPrSideBarBase
{
    TQ_OBJECT
  

public:
    KPrThumbBar(TQWidget *parent, KPrDocument *d, KPrView *v);
    ~KPrThumbBar();
    void setCurrentPage( int pg );
    void updateItem( int pagenr, bool sticky = false );
    void addItem( int pos );
    void moveItem( int oldPos, int newPos );
    void removeItem( int pos );
    void refreshItems ( bool offset = false );
    TQRect tip(const TQPoint &pos, TQString &title);

    bool uptodate;

signals:
    void showPage( int i );

public slots:
    void rebuildItems();

private slots:
    void itemClicked(TQIconViewItem *i);
    void slotContentsMoving(int x, int y);
    void slotRefreshItems();

private:
    TQPixmap getSlideThumb(int slideNr) const;

    ThumbToolTip *m_thumbTip;
    int m_offsetX;
    int m_offsetY;
};

class KPrOutline: public TDEListView, public KPrSideBarBase
{
    TQ_OBJECT
  

public:
    KPrOutline( TQWidget *parent, KPrDocument *d, KPrView *v );
    ~KPrOutline();
    void setCurrentPage( int pg );
    TQSize sizeHint() const { return TQSize( 145, TDEListView::sizeHint().height() ); }
    void updateItem( int pagenr, bool sticky = false);
    void addItem( int pos );
    void moveItem( int oldPos, int newPos );
    void removeItem( int pos );

protected:
    void contentsDropEvent( TQDropEvent *e );
    void moveItem( TQListViewItem *i, TQListViewItem *firstAfter, TQListViewItem *newAfter );
    OutlineSlideItem* slideItem( int pageNumber );
    bool acceptDrag( TQDropEvent* e ) const;

    virtual TQDragObject* dragObject();

signals: // all page numbers 0-based
    void showPage( int i );
    void movePage( int from, int to );
    void selectPage( int i, bool );

public slots:
    void rebuildItems();
    void renamePageTitle();

private slots:
    void itemClicked( TQListViewItem *i );
    void slotDropped( TQDropEvent *e, TQListViewItem *parent, TQListViewItem *target );
    void rightButtonPressed( TQListViewItem *i, const TQPoint &pnt, int c );
    void slotContextMenu( TDEListView*, TQListViewItem *item, const TQPoint &p );

private:
    TQListViewItem *m_movedItem, *m_movedAfter;
};

class KPrSideBar: public TQTabWidget
{
    TQ_OBJECT
  

public:
    KPrSideBar(TQWidget *parent, KPrDocument *d, KPrView *v);
    void setCurrentPage( int pg ) {
        m_outline->setCurrentPage(pg);
        m_thb->setCurrentPage(pg);
    };
    void setOn( int , bool ) { };
    //TQSize sizeHint() const { return TQSize( 120, TQTabWidget::sizeHint().height() ); };
    void updateItem( KPrPage *page );
    void addItem( int pos );
    void moveItem( int oldPos, int newPos );
    void removeItem( int pos );

    KPrOutline *outline() const { return m_outline; };
    KPrThumbBar *thumbBar() const { return m_thb; };

    void setViewMasterPage( bool _masterPage );
signals: // all page numbers 0-based
    void showPage( int i );
    void movePage( int from, int to );
    void selectPage( int i, bool );

public slots:
    //void rebuildItems() { m_outline->rebuildItems(); m_thb->rebuildItems();};
    void renamePageTitle() { m_outline->renamePageTitle(); };
    void currentChanged(TQWidget *tab);

private:
    KPrOutline *m_outline;
    KPrThumbBar *m_thb;

    KPrDocument *m_doc;
    KPrView *m_view;
};

#endif
