/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   daniel@Docter                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ROUNDBUTTON_H
#define ROUNDBUTTON_H

#include <tqbutton.h>
#include <tqpainter.h>
#include <kiconeffect.h>
#include <kpixmap.h>
#include <cassert>

class Menu;

class TDE_EXPORT RoundButton : public TQButton  //well, there were round buttons in the begining at least *g*
{
	TQ_OBJECT
	public:
        enum Type {Round, Commando, Submenu};
        RoundButton( TQWidget* parent=0, unsigned short rad= 32, const char* name= 0, WFlags f = 0);

        ~RoundButton();

		virtual void setRadius(int rad);
		virtual void setIcon(const TQString& path);
        virtual void setActive(bool mode);

        //This method should not be called on a RoundButton instance. Childclasses have to implement it.
        virtual Menu* execute(){ assert(0); return 0; }
        virtual Type type() const { return Round; }


    public slots:
		virtual void move(int x, int y);
		virtual void show();

	signals:
		void mouseIn(RoundButton* emitter);
		void mouseOut(RoundButton* emitter);


	protected:
		int radius;
		TQPixmap icon;
		TQString mIconPath;
		KPixmap background;
		TDEIconEffect mEffect;

		virtual void keyPressEvent(TQKeyEvent* evt);

		virtual void drawButtonLabel(TQPainter*);
		virtual void drawButton(TQPainter*);
		virtual bool event(TQEvent* evt);
};

#endif
