/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef LITERECIPEDB_H
#define LITERECIPEDB_H

#include "backends/qsqlrecipedb.h"

#include <tqstring.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_SQLITE3
#define SQLITE_DRIVER "TQSQLITE3"
#endif

class LiteRecipeDB : public TQSqlRecipeDB
{

	TQ_OBJECT

private:
	void createDB( void );

public:
	LiteRecipeDB( const TQString &DBName = DEFAULT_DB_NAME );
	~LiteRecipeDB( void );

	virtual int lastInsertID();

	virtual void createTable( const TQString &tableName );
	virtual void givePermissions(const TQString&, const TQString&, const TQString&, const TQString&){} //no permissions in this backend

protected:
	virtual TQString qsqlDriverPlugin() const
	{
		return SQLITE_DRIVER;
	}

	virtual TQString escapeAndEncode( const TQString &s ) const;

private:
	virtual void portOldDatabases( float version );
	virtual TQStringList backupCommand() const;
	virtual TQStringList restoreCommand() const;

	void addColumn( const TQString &new_table_sql, const TQString &new_col_info, const TQString &default_value, const TQString &table_name, int col_index );
};




#endif
