/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//For compatibility with old versions of KDE
#include <tdeversion.h>

//The filter is activated only if KDE version >= 3.3
#if defined(TDE_MAKE_VERSION) && TDE_VERSION >= TDE_MAKE_VERSION(3,3,0)

#include <tqpainter.h>

#include <tdelocale.h>

#include "logLineFilter.h"

LogLineFilter::LogLineFilter(TQWidget* parent, TDEListView* listView, const char* name) :
	TDEListViewSearchLine(parent, listView, name) {

	drawFilterMessage = true;
	
	repaint();
}


void LogLineFilter::drawContents(TQPainter *p) {
    TDEListViewSearchLine::drawContents( p );

    if ( drawFilterMessage == true && !hasFocus() ) {
        TQPen tmp = p->pen();
        p->setPen( palette().color( TQPalette::Disabled, TQColorGroup::Text ) );
        TQRect cr = contentsRect();

        //p->drawPixmap( 3, 3, SmallIcon("filter") );

        // Add two pixel margin on the left side
        cr.rLeft() += 3;
        p->drawText( cr, AlignAuto | AlignVCenter, i18n("Filter here...") );
        p->setPen( tmp );
    }
}


void LogLineFilter::focusInEvent( TQFocusEvent *ev )
{
    if ( drawFilterMessage == true ) {
        drawFilterMessage = false;
        repaint();
    }
    TDEListViewSearchLine::focusInEvent( ev );
}


void LogLineFilter::focusOutEvent( TQFocusEvent *ev )
{
    if ( text().isEmpty() ) {
        drawFilterMessage = true;
        repaint();
    }
    TDEListViewSearchLine::focusOutEvent( ev );
}


#endif
