#ifndef _KVI_COREACTIONS_H_
#define _KVI_COREACTIONS_H_
//=============================================================================
//
//   File : kvi_coreactions.h
//   Created on Mon 22 Nov 2004 02:30:47 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_action.h"
#include "kvi_kvs_action.h"
#include "kvi_pointerlist.h"

#include <tqtoolbutton.h>

class KviConnectAction : public KviAction
{
	TQ_OBJECT
  
public:
	KviConnectAction(TQObject * pParent);
protected:
	TQString m_szConnectString;
	TQString m_szAbortConnectionString;
	TQString m_szDisconnectString;
public:
	virtual bool addToPopupMenu(KviTalPopupMenu *p);
	virtual TQWidget * addToCustomToolBar(KviCustomToolBar *t);
protected:
	virtual void setup();
	virtual void reloadImages();
	virtual void activate();
	virtual void activeContextChanged();
	virtual void activeContextStateChanged();
};

class KviSeparatorAction : public KviAction
{
	TQ_OBJECT
  
public:
	KviSeparatorAction(TQObject * pParent);
public:
	virtual bool addToPopupMenu(KviTalPopupMenu *p);
	virtual TQWidget * addToCustomToolBar(KviCustomToolBar *t);
};

class KviTalPopupMenu;

class KviSubmenuAction : public KviKvsAction
{
	TQ_OBJECT
  
public:
	KviSubmenuAction(TQObject * pParent,
		const TQString &szName,
		const TQString &szScriptCode,
		const TQString &szVisibleName,
		const TQString &szDescription,
		KviActionCategory * pCategory = 0,
		const TQString &szBigIcon = TQString(),
		int iSmallIconId = 0,
		unsigned int uFlags = 0);
	~KviSubmenuAction();
protected:
	KviTalPopupMenu * m_pPopup;
protected:
	virtual void setup();
public:
	virtual bool addToPopupMenu(KviTalPopupMenu *p);
	virtual TQWidget * addToCustomToolBar(KviCustomToolBar *t);
protected slots:
	virtual void popupAboutToShow();
	virtual void popupActivated(int id);
};

class KviJoinChannelAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviJoinChannelAction(TQObject * pParent);
protected slots:
	virtual void popupAboutToShow();
	virtual void popupActivated(int);
};

class KviChangeNickAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviChangeNickAction(TQObject * pParent);
protected slots:
	void popupAboutToShow();
	void popupActivated(int);
};

class KviConnectToServerAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviConnectToServerAction(TQObject * pParent);
protected slots:
	void popupAboutToShow();
	void popupActivated(int);
};

class KviChangeUserModeAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviChangeUserModeAction(TQObject * pParent);
protected slots:
	void popupAboutToShow();
	void popupActivated(int);
};

class KviIrcToolsAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviIrcToolsAction(TQObject * pParent);
protected slots:
	void popupAboutToShow();
	void popupActivated(int);
};


class KviIrcOperationsAction : public KviSubmenuAction
{
	TQ_OBJECT
  
public:
	KviIrcOperationsAction(TQObject * pParent);
protected slots:
	void popupAboutToShow();
	void popupActivated(int);
};

#include "kvi_irctoolbar.h"

class KviIrcContextDisplayAction : public KviAction
{
	TQ_OBJECT
  
public:
	KviIrcContextDisplayAction(TQObject * pParent);
public:
	virtual bool addToPopupMenu(KviTalPopupMenu *p);
	virtual TQWidget * addToCustomToolBar(KviCustomToolBar *t);
	virtual void activeContextStateChanged();
	virtual void activeContextChanged();
	virtual void setEnabled(bool);
	virtual void setup();
};


class KviGoAwayAction : public KviKvsAction
{
	TQ_OBJECT
  
public:
	KviGoAwayAction(TQObject * pParent);
protected:
	TQString m_szAwayString;
	TQString m_szBackString;
public:
	virtual bool addToPopupMenu(KviTalPopupMenu *p);
	virtual TQWidget * addToCustomToolBar(KviCustomToolBar *t);
protected:
	virtual void setup();
	virtual void reloadImages();
	virtual void activeContextChanged();
	virtual void activeContextStateChanged();
};

#endif //!_KVI_COREACTIONS_H_
