/***************************************************************************
                          kxe_viewattributes.h  -  description
                             -------------------
    begin                : Thu Nov 22 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_VIEWATTRIBUTES_H
#define KXE_VIEWATTRIBUTES_H

#include <tqtable.h>
#include <tqdom.h>

/**
 * @author The KXMLEditor Team
 */
class KXE_ViewAttributes : public TQTable
{
		TQ_OBJECT

	public:

		KXE_ViewAttributes( TQWidget * pParent = 0, const char * pszName = 0 );

		/** Returns a pointer to the currently selected attribute or a null pointer. */
		TQDomAttr getSelectedAttribute() const;

		/** Changes the behaviour of this view to readonly or readwrite. */
		void setReadWrite( bool fReadWrite );

	public slots:

		/** Changes/Rebuilds the whole table according to the given element's attributes. */
		void slotChange( const TQDomElement & element );

	protected:

		/** the currently selected node */
		TQDomElement m_domElement;
    
	protected slots:

		/** Called, when a context menu was requested (connected to @ref TQTable::contextMenuRequested). */
		void slotContextMenuRequested( int nRow, int nCol, const TQPoint & pos );

		/** Called, when an item was changed via inplace editing. */
		void slotItemRenamedInplace( int nRow, int nCol );

	signals:

		/** Emitted, when a context menu is requested */
		void sigContextMenuRequested( const TQString & szMenuName, const TQPoint & pos );

    /** Emitted, when an attributes value was renamed via inplace editing. */
		void sigAttributeNameChangedInplace( const TQDomAttr &, const TQString );
    
		/** Emitted, when an attributes value was renamed via inplace editing. */
		void sigAttributeValueChangedInplace( const TQDomAttr &, const TQString );
};

#endif
