/*************************************************************************** 
                          xsldbgtemplatesimpl.cpp  -  description 
                             ------------------- 
    begin                : Fri Jan 4 2002 
    copyright            : (C) 2002 by keith Isdale 
    email                : k_isdale@tpg.com.au 
 ***************************************************************************/ 
 
/*************************************************************************** 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 ***************************************************************************/ 
#include <tqlistview.h> 
#include <tqlineedit.h> 
 
#include "xsldbgdebugger.h" 
#include "xsldbgtemplatesimpl.h" 
#include "xsldbgtemplatelistitem.h" 
 
XsldbgTemplatesImpl::XsldbgTemplatesImpl(XsldbgDebugger *debugger, 
	TQWidget *parent /*=0*/, const char *name /*=0*/) 
		:  XsldbgTemplates(parent, name), XsldbgDialogBase() 
{	 
	this->debugger = debugger; 
	 
	connect(debugger, TQ_SIGNAL(templateItem(TQString /* name*/, TQString /*mode*/, TQString /* fileName */, int /* lineNumber */)), 
		this, TQ_SLOT(slotProcTemplateItem(TQString /* name*/,  TQString /*mode*/, TQString /* fileName */, int /* lineNumber */))); 
	connect( templatesListView,  TQ_SIGNAL(selectionChanged(TQListViewItem *)), 
						this, TQ_SLOT(selectionChanged(TQListViewItem*))); 
						 
	show(); 
} 
 
XsldbgTemplatesImpl::~XsldbgTemplatesImpl(){ 
    debugger = 0L; 
} 
 
 
void XsldbgTemplatesImpl::slotProcTemplateItem(TQString  name, TQString mode, TQString  fileName , int  lineNumber ) 
{ 
	if (name.isNull()) 
		  templatesListView->clear(); 
	else 
		templatesListView->insertItem(new XsldbgTemplateListItem(templatesListView, 
																					fileName, lineNumber, name, mode)); 
} 
 
 
void XsldbgTemplatesImpl::selectionChanged(TQListViewItem *item) 
{ 
	XsldbgTemplateListItem *templateItem = dynamic_cast<XsldbgTemplateListItem*>(item); 
	if (templateItem){ 
		debugger->gotoLine(templateItem->getFileName(), templateItem->getLineNumber());			 
	} 
} 
 
void XsldbgTemplatesImpl::refresh() 
{ 
	debugger->fakeInput("templates", true) ; 
} 
 
 

#include "xsldbgtemplatesimpl.moc"
