/* ============================================================
 * File   : imagecollection.h
 * Authors: KIPI team developers (see AUTHORS files for details)
 *	    
 * Date   : 2004-02
 * Description :
 *
 * Copyright 2004 by the KIPI team
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */
 
/** @file imagecollection.h */

#ifndef KIPI_IMAGECOLLECTION_H
#define KIPI_IMAGECOLLECTION_H

// TQt includes

#include <tqstring.h>
#include <tqdatetime.h>

// KDE includes.

#include <kurl.h>
#include "libkipi/libkipi_export.h"

/** @namespace KIPI */
namespace KIPI
{
    class ImageCollectionShared;

    /** @class ImageCollection 
        Holds info about the collection
      */
    class LIBKIPI_EXPORT ImageCollection
    {
    public:
        TQString name() const;
        TQString comment() const;
        TQString category() const;
        TQDate date() const;
        KURL::List images() const;
        KURL path() const;
        KURL uploadPath() const;
        KURL uploadRoot() const;
        TQString uploadRootName() const;
        bool isDirectory() const;
        bool isValid() const;

        // Interface for host application + general stuff
        ImageCollection( ImageCollectionShared* );
        ImageCollection( const ImageCollection& other );
        ~ImageCollection();
        ImageCollection();
        ImageCollection& operator=( const ImageCollection& );

        bool operator==(const ImageCollection&) const;
    private:
        mutable KIPI::ImageCollectionShared* _data;
        void printNullError() const;
    };
}

#endif /* IMAGECOLLECTION_H */

