/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PIC30_COMPILE_H
#define PIC30_COMPILE_H

#include "tools/list/compile_process.h"

namespace PIC30
{
//-----------------------------------------------------------------------------
class Process : public Compile::Process
{
TQ_OBJECT
  
protected:
  virtual TQString deviceName() const { return _data.device; }
};

//-----------------------------------------------------------------------------
class CompileFile : public Process
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
  virtual void logStderrLine(const TQString &line);
};

//-----------------------------------------------------------------------------
class CompileStandaloneFile : public CompileFile
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
};

//-----------------------------------------------------------------------------
class CompileProjectFile : public CompileFile
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class AssembleFile : public Process
{
TQ_OBJECT
  
protected:
  virtual TQString outputFilepath() const { return filepath(PURL::Object); }
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
  virtual void logStderrLine(const TQString &line);
};

//-----------------------------------------------------------------------------
class AssembleStandaloneFile : public AssembleFile
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class AssembleProjectFile : public AssembleFile
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class Link : public Process
{
TQ_OBJECT
  
protected:
  virtual TQString outputFilepath() const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
  virtual void logStderrLine(const TQString &line);
};

//-----------------------------------------------------------------------------
class LinkStandalone : public Link
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class LinkProject : public Link
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class LibraryProject : public Process
{
TQ_OBJECT
  
protected:
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
  virtual void logStderrLine(const TQString &line);
};

//-----------------------------------------------------------------------------
class BinToHex : public Process
{
TQ_OBJECT
  
protected:
  virtual TQString inputFilepath(uint i) const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual TQString outputFiles() const;
  virtual void logStderrLine(const TQString &line);
};

} // namespace

#endif
