#ifndef _KURL_H_
#define _KURL_H_

#include <tqfile.h>

#include "common/global/global.h"

class KURL : public Q3Url
{
public:
  KURL() {}
  KURL(const TQString &s) : Q3Url(s) {}
  void cleanPath() {}
  bool isEmpty() const { return toString(false, false).isEmpty(); }
  TQString fileName(bool b) const { Q_UNUSED(b); Q_ASSERT(!b); return Q3Url::fileName(); }
  static KURL fromPathOrURL(const TQString &s) { return KURL(s); }
#if [[[TQT_VERSION IS DEPRECATED]]]>=0x040000
  bool operator <(const KURL &url) const { return path()<url.path(); }
  bool operator ==(const KURL &url) const { return path()==url.path(); }
  bool operator !=(const KURL &url) const { return path()!=url.path(); }
#endif
};

// ### DUMMY
class KTempFile
{
public:
  const TQFile *file() const { return 0; }
  TQFile *file() { return 0; }
};

#endif
